/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"hideUnsubscribeLink", "fromAddress"})
public class MailgunUpdateAllOf {
    public static final String JSON_PROPERTY_HIDE_UNSUBSCRIBE_LINK = "hideUnsubscribeLink";
    private Boolean hideUnsubscribeLink;
    public static final String JSON_PROPERTY_FROM_ADDRESS = "fromAddress";
    private JsonNullable<String> fromAddress = JsonNullable.undefined();

    public MailgunUpdateAllOf hideUnsubscribeLink(Boolean hideUnsubscribeLink) {
        this.hideUnsubscribeLink = hideUnsubscribeLink;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A boolean value indicating whether the unsubscribe link should be omitted from outgoing emails. When enabled, it is expected that the business is providing the user a way to unsubscribe by some other means. By default, the unsubscribe link will be included in all outgoing emails.")
    @JsonProperty(value="hideUnsubscribeLink")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHideUnsubscribeLink() {
        return this.hideUnsubscribeLink;
    }

    public void setHideUnsubscribeLink(Boolean hideUnsubscribeLink) {
        this.hideUnsubscribeLink = hideUnsubscribeLink;
    }

    public MailgunUpdateAllOf fromAddress(String fromAddress) {
        this.fromAddress = JsonNullable.of((Object)fromAddress);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="test@sandbox123.mailgun.org", value="Email address to use as the From and Reply-To address if it must be different from incomingAddress. Only use this option if the address that you supply is configured to forward emails to the incomingAddress, otherwise user replies will be lost. You must also make sure that the domain is properly configured as a mail provider so as to not be flagged as spam by the user\u2019s email client. May be unset with null.")
    @JsonIgnore
    public String getFromAddress() {
        return (String)this.fromAddress.orElse(null);
    }

    @JsonProperty(value="fromAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getFromAddress_JsonNullable() {
        return this.fromAddress;
    }

    @JsonProperty(value="fromAddress")
    public void setFromAddress_JsonNullable(JsonNullable<String> fromAddress) {
        this.fromAddress = fromAddress;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = JsonNullable.of((Object)fromAddress);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MailgunUpdateAllOf mailgunUpdateAllOf = (MailgunUpdateAllOf)o;
        return Objects.equals(this.hideUnsubscribeLink, mailgunUpdateAllOf.hideUnsubscribeLink) && Objects.equals(this.fromAddress, mailgunUpdateAllOf.fromAddress);
    }

    public int hashCode() {
        return Objects.hash(this.hideUnsubscribeLink, this.fromAddress);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MailgunUpdateAllOf {\n");
        sb.append("    hideUnsubscribeLink: ").append(this.toIndentedString(this.hideUnsubscribeLink)).append("\n");
        sb.append("    fromAddress: ").append(this.toIndentedString(this.fromAddress)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

