/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.api;

import com.zendesk.sunshine_conversations_client.ApiClient;
import com.zendesk.sunshine_conversations_client.ApiException;
import com.zendesk.sunshine_conversations_client.Configuration;
import com.zendesk.sunshine_conversations_client.Pair;
import com.zendesk.sunshine_conversations_client.model.AppKeyCreateBody;
import com.zendesk.sunshine_conversations_client.model.AppKeyListResponse;
import com.zendesk.sunshine_conversations_client.model.AppKeyResponse;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;

public class AppKeysApi {
    private ApiClient apiClient;

    public AppKeysApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AppKeysApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public AppKeyResponse createAppKey(AppKeyCreateBody appKeyCreateBody, String appId) throws ApiException {
        AppKeyCreateBody localVarPostBody = appKeyCreateBody;
        if (appKeyCreateBody == null) {
            throw new ApiException(400, "Missing the required parameter 'appKeyCreateBody' when calling createAppKey");
        }
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling createAppKey");
        }
        String localVarPath = "/v2/apps/{appId}/keys".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<AppKeyResponse> localVarReturnType = new GenericType<AppKeyResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Object deleteAppKey(String appId, String keyId) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling deleteAppKey");
        }
        if (keyId == null) {
            throw new ApiException(400, "Missing the required parameter 'keyId' when calling deleteAppKey");
        }
        String localVarPath = "/v2/apps/{appId}/keys/{keyId}".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{keyId\\}", this.apiClient.escapeString(keyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AppKeyResponse getAppKey(String appId, String keyId) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling getAppKey");
        }
        if (keyId == null) {
            throw new ApiException(400, "Missing the required parameter 'keyId' when calling getAppKey");
        }
        String localVarPath = "/v2/apps/{appId}/keys/{keyId}".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{keyId\\}", this.apiClient.escapeString(keyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<AppKeyResponse> localVarReturnType = new GenericType<AppKeyResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AppKeyListResponse listAppKeys(String appId) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling listAppKeys");
        }
        String localVarPath = "/v2/apps/{appId}/keys".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<AppKeyListResponse> localVarReturnType = new GenericType<AppKeyListResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AppKeyResponse createAppKey(String bearerToken, AppKeyCreateBody appKeyCreateBody, String appId) throws ApiException {
        AppKeyCreateBody localVarPostBody = appKeyCreateBody;
        if (appKeyCreateBody == null) {
            throw new ApiException(400, "Missing the required parameter 'appKeyCreateBody' when calling createAppKey");
        }
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling createAppKey");
        }
        String localVarPath = "/v2/apps/{appId}/keys".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Authorization", "Bearer " + bearerToken);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<AppKeyResponse> localVarReturnType = new GenericType<AppKeyResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Object deleteAppKey(String bearerToken, String appId, String keyId) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling deleteAppKey");
        }
        if (keyId == null) {
            throw new ApiException(400, "Missing the required parameter 'keyId' when calling deleteAppKey");
        }
        String localVarPath = "/v2/apps/{appId}/keys/{keyId}".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{keyId\\}", this.apiClient.escapeString(keyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Authorization", "Bearer " + bearerToken);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AppKeyResponse getAppKey(String bearerToken, String appId, String keyId) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling getAppKey");
        }
        if (keyId == null) {
            throw new ApiException(400, "Missing the required parameter 'keyId' when calling getAppKey");
        }
        String localVarPath = "/v2/apps/{appId}/keys/{keyId}".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{keyId\\}", this.apiClient.escapeString(keyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Authorization", "Bearer " + bearerToken);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<AppKeyResponse> localVarReturnType = new GenericType<AppKeyResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AppKeyListResponse listAppKeys(String bearerToken, String appId) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling listAppKeys");
        }
        String localVarPath = "/v2/apps/{appId}/keys".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Authorization", "Bearer " + bearerToken);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<AppKeyListResponse> localVarReturnType = new GenericType<AppKeyListResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

