/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.ActionSubset;
import com.zendesk.sunshine_conversations_client.model.Content;
import com.zendesk.sunshine_conversations_client.model.Item;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="List messages are a vertically scrollable set of items that may each contain text, an image, and message actions. Not all messaging channels fully support list messages. * Facebook Messenger and WeChat have native support. * For LINE and our Android, iOS and Web SDK, Sunshine Conversations converts list messages to carousel. * On WhatsApp, Telegram and Twitter, Sunshine Conversations converts list messages to multiple rich messages. * On all other platforms, Sunshine Conversations converts list messages to raw text. ")
@JsonPropertyOrder(value={"type", "items", "actions"})
public class ListMessage
implements Content {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type = "list";
    public static final String JSON_PROPERTY_ITEMS = "items";
    private List<Item> items = new ArrayList<Item>();
    public static final String JSON_PROPERTY_ACTIONS = "actions";
    private List<ActionSubset> actions = null;

    public ListMessage type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @ApiModelProperty(required=true, value="The type of message.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ListMessage items(List<Item> items) {
        this.items = items;
        return this;
    }

    public ListMessage addItemsItem(Item itemsItem) {
        this.items.add(itemsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An array of objects representing the items associated with the message. Only present in carousel and list type messages.")
    @JsonProperty(value="items")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<Item> getItems() {
        return this.items;
    }

    public void setItems(List<Item> items) {
        this.items = items;
    }

    public ListMessage actions(List<ActionSubset> actions) {
        this.actions = actions;
        return this;
    }

    public ListMessage addActionsItem(ActionSubset actionsItem) {
        if (this.actions == null) {
            this.actions = new ArrayList<ActionSubset>();
        }
        this.actions.add(actionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of objects representing the actions associated with the message. The array length is limited by the third party channel.")
    @JsonProperty(value="actions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ActionSubset> getActions() {
        return this.actions;
    }

    public void setActions(List<ActionSubset> actions) {
        this.actions = actions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListMessage listMessage = (ListMessage)o;
        return Objects.equals(this.type, listMessage.type) && Objects.equals(this.items, listMessage.items) && Objects.equals(this.actions, listMessage.actions);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.items, this.actions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListMessage {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    actions: ").append(this.toIndentedString(this.actions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

