/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.AppleMessageOverridePayload;
import com.zendesk.sunshine_conversations_client.model.MessageOverridePayload;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;

@ApiModel(description="A raw payload containing a message that is sent directly to a channel. Messages for [Apple Messages for Business](https://docs.smooch.io/guide/apple-messages-for-business/#passthrough-api), [Line](https://docs.smooch.io/guide/line/#passthrough-api), [Messenger](https://docs.smooch.io/guide/facebook-messenger/#passthrough-api), [Whatsapp](https://docs.smooch.io/guide/whatsapp/#passthrough-api) channels are supported.")
@JsonPropertyOrder(value={"apple", "line", "messenger", "whatsapp"})
public class MessageOverride {
    public static final String JSON_PROPERTY_APPLE = "apple";
    private AppleMessageOverridePayload apple;
    public static final String JSON_PROPERTY_LINE = "line";
    private MessageOverridePayload line;
    public static final String JSON_PROPERTY_MESSENGER = "messenger";
    private MessageOverridePayload messenger;
    public static final String JSON_PROPERTY_WHATSAPP = "whatsapp";
    private MessageOverridePayload whatsapp;

    public MessageOverride apple(AppleMessageOverridePayload apple) {
        this.apple = apple;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="apple")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AppleMessageOverridePayload getApple() {
        return this.apple;
    }

    public void setApple(AppleMessageOverridePayload apple) {
        this.apple = apple;
    }

    public MessageOverride line(MessageOverridePayload line) {
        this.line = line;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="line")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MessageOverridePayload getLine() {
        return this.line;
    }

    public void setLine(MessageOverridePayload line) {
        this.line = line;
    }

    public MessageOverride messenger(MessageOverridePayload messenger) {
        this.messenger = messenger;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="messenger")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MessageOverridePayload getMessenger() {
        return this.messenger;
    }

    public void setMessenger(MessageOverridePayload messenger) {
        this.messenger = messenger;
    }

    public MessageOverride whatsapp(MessageOverridePayload whatsapp) {
        this.whatsapp = whatsapp;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="whatsapp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MessageOverridePayload getWhatsapp() {
        return this.whatsapp;
    }

    public void setWhatsapp(MessageOverridePayload whatsapp) {
        this.whatsapp = whatsapp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageOverride messageOverride = (MessageOverride)o;
        return Objects.equals(this.apple, messageOverride.apple) && Objects.equals(this.line, messageOverride.line) && Objects.equals(this.messenger, messageOverride.messenger) && Objects.equals(this.whatsapp, messageOverride.whatsapp);
    }

    public int hashCode() {
        return Objects.hash(this.apple, this.line, this.messenger, this.whatsapp);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MessageOverride {\n");
        sb.append("    apple: ").append(this.toIndentedString(this.apple)).append("\n");
        sb.append("    line: ").append(this.toIndentedString(this.line)).append("\n");
        sb.append("    messenger: ").append(this.toIndentedString(this.messenger)).append("\n");
        sb.append("    whatsapp: ").append(this.toIndentedString(this.whatsapp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

