/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"switchboardIntegration", "metadata"})
public class PassControlBody {
    public static final String JSON_PROPERTY_SWITCHBOARD_INTEGRATION = "switchboardIntegration";
    private String switchboardIntegration;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private Map metadata = null;

    public PassControlBody switchboardIntegration(String switchboardIntegration) {
        this.switchboardIntegration = switchboardIntegration;
        return this;
    }

    @ApiModelProperty(example="next", required=true, value="The id or the name of the switchboard integration that will become active. May also use the `next` keyword to transfer control to the next switchboard integration designated in the switchboard hierarchy configuration")
    @JsonProperty(value="switchboardIntegration")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSwitchboardIntegration() {
        return this.switchboardIntegration;
    }

    public void setSwitchboardIntegration(String switchboardIntegration) {
        this.switchboardIntegration = switchboardIntegration;
    }

    public PassControlBody metadata(Map metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Flat object containing custom properties. Strings, numbers and booleans are the only supported format that can be passed to metadata. The metadata is limited to 4KB in size. The metadata object will be included in the `switchboard:passControl` webhook.")
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PassControlBody passControlBody = (PassControlBody)o;
        return Objects.equals(this.switchboardIntegration, passControlBody.switchboardIntegration) && Objects.equals(this.metadata, passControlBody.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.switchboardIntegration, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PassControlBody {\n");
        sb.append("    switchboardIntegration: ").append(this.toIndentedString(this.switchboardIntegration)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

