/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Nested object containing additional information.")
@JsonPropertyOrder(value={"source", "type", "adId"})
public class ReferralDetails {
    public static final String JSON_PROPERTY_SOURCE = "source";
    private String source;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_AD_ID = "adId";
    private JsonNullable<String> adId = JsonNullable.undefined();

    public ReferralDetails source(String source) {
        this.source = source;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="MESSENGER_CODE", value="The source of the referral - MESSENGER_CODE, ADS etc\u2026")
    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public ReferralDetails type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="OPEN-THREAD", value="The type of referral, typically OPEN-THREAD.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ReferralDetails adId(String adId) {
        this.adId = JsonNullable.of((Object)adId);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="4216212847577", value="If the referral came from an ad, this field will be present with the ad\u2019s Id.")
    @JsonIgnore
    public String getAdId() {
        return (String)this.adId.orElse(null);
    }

    @JsonProperty(value="adId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getAdId_JsonNullable() {
        return this.adId;
    }

    @JsonProperty(value="adId")
    public void setAdId_JsonNullable(JsonNullable<String> adId) {
        this.adId = adId;
    }

    public void setAdId(String adId) {
        this.adId = JsonNullable.of((Object)adId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReferralDetails referralDetails = (ReferralDetails)o;
        return Objects.equals(this.source, referralDetails.source) && Objects.equals(this.type, referralDetails.type) && Objects.equals(this.adId, referralDetails.adId);
    }

    public int hashCode() {
        return Objects.hash(this.source, this.type, this.adId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReferralDetails {\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    adId: ").append(this.toIndentedString(this.adId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

