/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.zendesk.sunshine_conversations_client.model.Android;
import com.zendesk.sunshine_conversations_client.model.Apple;
import com.zendesk.sunshine_conversations_client.model.Custom;
import com.zendesk.sunshine_conversations_client.model.DefaultResponderDefaultResponder;
import com.zendesk.sunshine_conversations_client.model.Instagram;
import com.zendesk.sunshine_conversations_client.model.Integration;
import com.zendesk.sunshine_conversations_client.model.Ios;
import com.zendesk.sunshine_conversations_client.model.Line;
import com.zendesk.sunshine_conversations_client.model.Mailgun;
import com.zendesk.sunshine_conversations_client.model.Messagebird;
import com.zendesk.sunshine_conversations_client.model.Messenger;
import com.zendesk.sunshine_conversations_client.model.PrechatCapture;
import com.zendesk.sunshine_conversations_client.model.Telegram;
import com.zendesk.sunshine_conversations_client.model.Twilio;
import com.zendesk.sunshine_conversations_client.model.Twitter;
import com.zendesk.sunshine_conversations_client.model.Unity;
import com.zendesk.sunshine_conversations_client.model.Viber;
import com.zendesk.sunshine_conversations_client.model.Whatsapp;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"type", "brandColor", "fixedIntroPane", "conversationColor", "actionColor", "displayStyle", "buttonIconUrl", "buttonWidth", "buttonHeight", "integrationOrder", "businessName", "businessIconUrl", "backgroundImageUrl", "originWhitelist", "prechatCapture", "canUserSeeConversationList", "canUserCreateMoreConversations", "attachmentsEnabled", "defaultResponderId", "defaultResponder"})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=Android.class, name="android"), @JsonSubTypes.Type(value=Apple.class, name="apple"), @JsonSubTypes.Type(value=Custom.class, name="custom"), @JsonSubTypes.Type(value=Instagram.class, name="instagram"), @JsonSubTypes.Type(value=Ios.class, name="ios"), @JsonSubTypes.Type(value=Line.class, name="line"), @JsonSubTypes.Type(value=Mailgun.class, name="mailgun"), @JsonSubTypes.Type(value=Messagebird.class, name="messagebird"), @JsonSubTypes.Type(value=Messenger.class, name="messenger"), @JsonSubTypes.Type(value=Telegram.class, name="telegram"), @JsonSubTypes.Type(value=Twilio.class, name="twilio"), @JsonSubTypes.Type(value=Twitter.class, name="twitter"), @JsonSubTypes.Type(value=Unity.class, name="unity"), @JsonSubTypes.Type(value=Viber.class, name="viber"), @JsonSubTypes.Type(value=Web.class, name="web"), @JsonSubTypes.Type(value=Whatsapp.class, name="whatsapp")})
public class Web
extends Integration {
    public static final String JSON_PROPERTY_TYPE = "type";
    protected String type = "web";
    public static final String JSON_PROPERTY_BRAND_COLOR = "brandColor";
    private String brandColor = "65758e";
    public static final String JSON_PROPERTY_FIXED_INTRO_PANE = "fixedIntroPane";
    private Boolean fixedIntroPane = false;
    public static final String JSON_PROPERTY_CONVERSATION_COLOR = "conversationColor";
    private String conversationColor = "0099ff";
    public static final String JSON_PROPERTY_ACTION_COLOR = "actionColor";
    private String actionColor = "0099ff";
    public static final String JSON_PROPERTY_DISPLAY_STYLE = "displayStyle";
    private String displayStyle = "button";
    public static final String JSON_PROPERTY_BUTTON_ICON_URL = "buttonIconUrl";
    private JsonNullable<String> buttonIconUrl = JsonNullable.undefined();
    public static final String JSON_PROPERTY_BUTTON_WIDTH = "buttonWidth";
    private String buttonWidth = "58";
    public static final String JSON_PROPERTY_BUTTON_HEIGHT = "buttonHeight";
    private String buttonHeight = "58";
    public static final String JSON_PROPERTY_INTEGRATION_ORDER = "integrationOrder";
    private JsonNullable<List<String>> integrationOrder = JsonNullable.undefined();
    public static final String JSON_PROPERTY_BUSINESS_NAME = "businessName";
    private String businessName;
    public static final String JSON_PROPERTY_BUSINESS_ICON_URL = "businessIconUrl";
    private String businessIconUrl;
    public static final String JSON_PROPERTY_BACKGROUND_IMAGE_URL = "backgroundImageUrl";
    private String backgroundImageUrl;
    public static final String JSON_PROPERTY_ORIGIN_WHITELIST = "originWhitelist";
    private JsonNullable<List<String>> originWhitelist = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PRECHAT_CAPTURE = "prechatCapture";
    private PrechatCapture prechatCapture = null;
    public static final String JSON_PROPERTY_CAN_USER_SEE_CONVERSATION_LIST = "canUserSeeConversationList";
    private Boolean canUserSeeConversationList;
    public static final String JSON_PROPERTY_CAN_USER_CREATE_MORE_CONVERSATIONS = "canUserCreateMoreConversations";
    private Boolean canUserCreateMoreConversations;
    public static final String JSON_PROPERTY_ATTACHMENTS_ENABLED = "attachmentsEnabled";
    private Boolean attachmentsEnabled;
    public static final String JSON_PROPERTY_DEFAULT_RESPONDER_ID = "defaultResponderId";
    private JsonNullable<String> defaultResponderId = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DEFAULT_RESPONDER = "defaultResponder";
    private JsonNullable<DefaultResponderDefaultResponder> defaultResponder = JsonNullable.undefined();

    @Override
    public Web type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @Nullable
    @ApiModelProperty(value="To configure a Web Messenger integration, acquire the required information and call the Create Integration endpoint. ")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public Web brandColor(String brandColor) {
        this.brandColor = brandColor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="This color will be used in the messenger header and the button or tab in idle state. Must be a 3 or 6-character hexadecimal color. ")
    @JsonProperty(value="brandColor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBrandColor() {
        return this.brandColor;
    }

    public void setBrandColor(String brandColor) {
        this.brandColor = brandColor;
    }

    public Web fixedIntroPane(Boolean fixedIntroPane) {
        this.fixedIntroPane = fixedIntroPane;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When true, the introduction pane will be pinned at the top of the conversation instead of scrolling with it. ")
    @JsonProperty(value="fixedIntroPane")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getFixedIntroPane() {
        return this.fixedIntroPane;
    }

    public void setFixedIntroPane(Boolean fixedIntroPane) {
        this.fixedIntroPane = fixedIntroPane;
    }

    public Web conversationColor(String conversationColor) {
        this.conversationColor = conversationColor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="This color will be used for customer messages, quick replies and actions in the footer. Must be a 3 or 6-character hexadecimal color. ")
    @JsonProperty(value="conversationColor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getConversationColor() {
        return this.conversationColor;
    }

    public void setConversationColor(String conversationColor) {
        this.conversationColor = conversationColor;
    }

    public Web actionColor(String actionColor) {
        this.actionColor = actionColor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="This color will be used for call-to-actions inside your messages. Must be a 3 or 6-character hexadecimal color. ")
    @JsonProperty(value="actionColor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getActionColor() {
        return this.actionColor;
    }

    public void setActionColor(String actionColor) {
        this.actionColor = actionColor;
    }

    public Web displayStyle(String displayStyle) {
        this.displayStyle = displayStyle;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Choose how the messenger will appear on your website. Must be either button or tab. ")
    @JsonProperty(value="displayStyle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayStyle() {
        return this.displayStyle;
    }

    public void setDisplayStyle(String displayStyle) {
        this.displayStyle = displayStyle;
    }

    public Web buttonIconUrl(String buttonIconUrl) {
        this.buttonIconUrl = JsonNullable.of((Object)buttonIconUrl);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://domain.com/images/avatar.png", value="With the button style Web Messenger, you have the option of selecting your own button icon. The image must be at least 200 x 200 pixels and must be in either JPG, PNG, or GIF format. ")
    @JsonIgnore
    public String getButtonIconUrl() {
        return (String)this.buttonIconUrl.orElse(null);
    }

    @JsonProperty(value="buttonIconUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getButtonIconUrl_JsonNullable() {
        return this.buttonIconUrl;
    }

    @JsonProperty(value="buttonIconUrl")
    public void setButtonIconUrl_JsonNullable(JsonNullable<String> buttonIconUrl) {
        this.buttonIconUrl = buttonIconUrl;
    }

    public void setButtonIconUrl(String buttonIconUrl) {
        this.buttonIconUrl = JsonNullable.of((Object)buttonIconUrl);
    }

    public Web buttonWidth(String buttonWidth) {
        this.buttonWidth = buttonWidth;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="With the button style Web Messenger, you have the option of specifying the button width. ")
    @JsonProperty(value="buttonWidth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getButtonWidth() {
        return this.buttonWidth;
    }

    public void setButtonWidth(String buttonWidth) {
        this.buttonWidth = buttonWidth;
    }

    public Web buttonHeight(String buttonHeight) {
        this.buttonHeight = buttonHeight;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="With the button style Web Messenger, you have the option of specifying the button height. ")
    @JsonProperty(value="buttonHeight")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getButtonHeight() {
        return this.buttonHeight;
    }

    public void setButtonHeight(String buttonHeight) {
        this.buttonHeight = buttonHeight;
    }

    public Web integrationOrder(List<String> integrationOrder) {
        this.integrationOrder = JsonNullable.of(integrationOrder);
        return this;
    }

    public Web addIntegrationOrderItem(String integrationOrderItem) {
        if (this.integrationOrder == null || !this.integrationOrder.isPresent()) {
            this.integrationOrder = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.integrationOrder.get()).add(integrationOrderItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"59fc8466260f48003505228b\", \"59d79780481d34002b7d3617\"]", value="Array of integration IDs, order will be reflected in the Web Messenger. When set, only integrations from this list will be displayed in the Web Messenger. If unset, all integrations will be displayed. ")
    @JsonIgnore
    public List<String> getIntegrationOrder() {
        return (List)this.integrationOrder.orElse(null);
    }

    @JsonProperty(value="integrationOrder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<String>> getIntegrationOrder_JsonNullable() {
        return this.integrationOrder;
    }

    @JsonProperty(value="integrationOrder")
    public void setIntegrationOrder_JsonNullable(JsonNullable<List<String>> integrationOrder) {
        this.integrationOrder = integrationOrder;
    }

    public void setIntegrationOrder(List<String> integrationOrder) {
        this.integrationOrder = JsonNullable.of(integrationOrder);
    }

    public Web businessName(String businessName) {
        this.businessName = businessName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Kent Shop", value="A custom business name for the Web Messenger.")
    @JsonProperty(value="businessName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBusinessName() {
        return this.businessName;
    }

    public void setBusinessName(String businessName) {
        this.businessName = businessName;
    }

    public Web businessIconUrl(String businessIconUrl) {
        this.businessIconUrl = businessIconUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://www.gravatar.com/image.jpg", value="A custom business icon url for the Web Messenger. The image must be at least 200 x 200 pixels and must be in either JPG, PNG, or GIF format. ")
    @JsonProperty(value="businessIconUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBusinessIconUrl() {
        return this.businessIconUrl;
    }

    public void setBusinessIconUrl(String businessIconUrl) {
        this.businessIconUrl = businessIconUrl;
    }

    public Web backgroundImageUrl(String backgroundImageUrl) {
        this.backgroundImageUrl = backgroundImageUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://a-beautiful-tile.png", value="A background image url for the conversation. Image will be tiled to fit the window. ")
    @JsonProperty(value="backgroundImageUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBackgroundImageUrl() {
        return this.backgroundImageUrl;
    }

    public void setBackgroundImageUrl(String backgroundImageUrl) {
        this.backgroundImageUrl = backgroundImageUrl;
    }

    public Web originWhitelist(List<String> originWhitelist) {
        this.originWhitelist = JsonNullable.of(originWhitelist);
        return this;
    }

    public Web addOriginWhitelistItem(String originWhitelistItem) {
        if (this.originWhitelist == null || !this.originWhitelist.isPresent()) {
            this.originWhitelist = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.originWhitelist.get()).add(originWhitelistItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://yourdomain.com", value="A list of origins to whitelist. When set, only the origins from this list will be able to initialize the Web Messenger. If unset, all origins are whitelisted. The elements in the list should follow the serialized-origin format from RFC 6454: scheme \"://\" host [ \":\" port ], where scheme is http or https. ")
    @JsonIgnore
    public List<String> getOriginWhitelist() {
        return (List)this.originWhitelist.orElse(null);
    }

    @JsonProperty(value="originWhitelist")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<String>> getOriginWhitelist_JsonNullable() {
        return this.originWhitelist;
    }

    @JsonProperty(value="originWhitelist")
    public void setOriginWhitelist_JsonNullable(JsonNullable<List<String>> originWhitelist) {
        this.originWhitelist = originWhitelist;
    }

    public void setOriginWhitelist(List<String> originWhitelist) {
        this.originWhitelist = JsonNullable.of(originWhitelist);
    }

    public Web prechatCapture(PrechatCapture prechatCapture) {
        this.prechatCapture = prechatCapture;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Object whose properties can be set to specify the add-on\u2019s options. See the [guide](https://docs.smooch.io/guide/web-messenger/#prechat-capture) to learn more about Prechat Capture. ")
    @JsonProperty(value="prechatCapture")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PrechatCapture getPrechatCapture() {
        return this.prechatCapture;
    }

    public void setPrechatCapture(PrechatCapture prechatCapture) {
        this.prechatCapture = prechatCapture;
    }

    public Web canUserSeeConversationList(Boolean canUserSeeConversationList) {
        this.canUserSeeConversationList = canUserSeeConversationList;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Allows users to view their list of conversations. By default, the list of conversations will be visible. *This setting only applies to apps where `settings.multiConvoEnabled` is set to `true`*. ")
    @JsonProperty(value="canUserSeeConversationList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCanUserSeeConversationList() {
        return this.canUserSeeConversationList;
    }

    public void setCanUserSeeConversationList(Boolean canUserSeeConversationList) {
        this.canUserSeeConversationList = canUserSeeConversationList;
    }

    public Web canUserCreateMoreConversations(Boolean canUserCreateMoreConversations) {
        this.canUserCreateMoreConversations = canUserCreateMoreConversations;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Allows users to create more than one conversation on the web messenger integration. ")
    @JsonProperty(value="canUserCreateMoreConversations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCanUserCreateMoreConversations() {
        return this.canUserCreateMoreConversations;
    }

    public void setCanUserCreateMoreConversations(Boolean canUserCreateMoreConversations) {
        this.canUserCreateMoreConversations = canUserCreateMoreConversations;
    }

    @Nullable
    @ApiModelProperty(value="Allows users to send attachments. By default, the setting is set to true. This setting can only be configured in Zendesk Admin Center. ")
    @JsonProperty(value="attachmentsEnabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAttachmentsEnabled() {
        return this.attachmentsEnabled;
    }

    public Web defaultResponderId(String defaultResponderId) {
        this.defaultResponderId = JsonNullable.of((Object)defaultResponderId);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The default responder ID for the integration. This is the ID of the responder that will be used to send messages to the user. For more information, refer to <a href=\"https://docs.smooch.io/guide/switchboard/#per-channel-default-responder\">Per-channel default responder</a> guide. ")
    @JsonIgnore
    public String getDefaultResponderId() {
        return (String)this.defaultResponderId.orElse(null);
    }

    @JsonProperty(value="defaultResponderId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDefaultResponderId_JsonNullable() {
        return this.defaultResponderId;
    }

    @JsonProperty(value="defaultResponderId")
    public void setDefaultResponderId_JsonNullable(JsonNullable<String> defaultResponderId) {
        this.defaultResponderId = defaultResponderId;
    }

    public void setDefaultResponderId(String defaultResponderId) {
        this.defaultResponderId = JsonNullable.of((Object)defaultResponderId);
    }

    public Web defaultResponder(DefaultResponderDefaultResponder defaultResponder) {
        this.defaultResponder = JsonNullable.of((Object)defaultResponder);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public DefaultResponderDefaultResponder getDefaultResponder() {
        return (DefaultResponderDefaultResponder)this.defaultResponder.orElse(null);
    }

    @JsonProperty(value="defaultResponder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<DefaultResponderDefaultResponder> getDefaultResponder_JsonNullable() {
        return this.defaultResponder;
    }

    @JsonProperty(value="defaultResponder")
    public void setDefaultResponder_JsonNullable(JsonNullable<DefaultResponderDefaultResponder> defaultResponder) {
        this.defaultResponder = defaultResponder;
    }

    public void setDefaultResponder(DefaultResponderDefaultResponder defaultResponder) {
        this.defaultResponder = JsonNullable.of((Object)defaultResponder);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Web web = (Web)o;
        return Objects.equals(this.type, web.type) && Objects.equals(this.brandColor, web.brandColor) && Objects.equals(this.fixedIntroPane, web.fixedIntroPane) && Objects.equals(this.conversationColor, web.conversationColor) && Objects.equals(this.actionColor, web.actionColor) && Objects.equals(this.displayStyle, web.displayStyle) && Objects.equals(this.buttonIconUrl, web.buttonIconUrl) && Objects.equals(this.buttonWidth, web.buttonWidth) && Objects.equals(this.buttonHeight, web.buttonHeight) && Objects.equals(this.integrationOrder, web.integrationOrder) && Objects.equals(this.businessName, web.businessName) && Objects.equals(this.businessIconUrl, web.businessIconUrl) && Objects.equals(this.backgroundImageUrl, web.backgroundImageUrl) && Objects.equals(this.originWhitelist, web.originWhitelist) && Objects.equals(this.prechatCapture, web.prechatCapture) && Objects.equals(this.canUserSeeConversationList, web.canUserSeeConversationList) && Objects.equals(this.canUserCreateMoreConversations, web.canUserCreateMoreConversations) && Objects.equals(this.attachmentsEnabled, web.attachmentsEnabled) && Objects.equals(this.defaultResponderId, web.defaultResponderId) && Objects.equals(this.defaultResponder, web.defaultResponder) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type, this.brandColor, this.fixedIntroPane, this.conversationColor, this.actionColor, this.displayStyle, this.buttonIconUrl, this.buttonWidth, this.buttonHeight, this.integrationOrder, this.businessName, this.businessIconUrl, this.backgroundImageUrl, this.originWhitelist, this.prechatCapture, this.canUserSeeConversationList, this.canUserCreateMoreConversations, this.attachmentsEnabled, this.defaultResponderId, this.defaultResponder, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Web {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    brandColor: ").append(this.toIndentedString(this.brandColor)).append("\n");
        sb.append("    fixedIntroPane: ").append(this.toIndentedString(this.fixedIntroPane)).append("\n");
        sb.append("    conversationColor: ").append(this.toIndentedString(this.conversationColor)).append("\n");
        sb.append("    actionColor: ").append(this.toIndentedString(this.actionColor)).append("\n");
        sb.append("    displayStyle: ").append(this.toIndentedString(this.displayStyle)).append("\n");
        sb.append("    buttonIconUrl: ").append(this.toIndentedString(this.buttonIconUrl)).append("\n");
        sb.append("    buttonWidth: ").append(this.toIndentedString(this.buttonWidth)).append("\n");
        sb.append("    buttonHeight: ").append(this.toIndentedString(this.buttonHeight)).append("\n");
        sb.append("    integrationOrder: ").append(this.toIndentedString(this.integrationOrder)).append("\n");
        sb.append("    businessName: ").append(this.toIndentedString(this.businessName)).append("\n");
        sb.append("    businessIconUrl: ").append(this.toIndentedString(this.businessIconUrl)).append("\n");
        sb.append("    backgroundImageUrl: ").append(this.toIndentedString(this.backgroundImageUrl)).append("\n");
        sb.append("    originWhitelist: ").append(this.toIndentedString(this.originWhitelist)).append("\n");
        sb.append("    prechatCapture: ").append(this.toIndentedString(this.prechatCapture)).append("\n");
        sb.append("    canUserSeeConversationList: ").append(this.toIndentedString(this.canUserSeeConversationList)).append("\n");
        sb.append("    canUserCreateMoreConversations: ").append(this.toIndentedString(this.canUserCreateMoreConversations)).append("\n");
        sb.append("    attachmentsEnabled: ").append(this.toIndentedString(this.attachmentsEnabled)).append("\n");
        sb.append("    defaultResponderId: ").append(this.toIndentedString(this.defaultResponderId)).append("\n");
        sb.append("    defaultResponder: ").append(this.toIndentedString(this.defaultResponder)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

