/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.api;

import com.zendesk.sunshine_conversations_client.ApiClient;
import com.zendesk.sunshine_conversations_client.ApiException;
import com.zendesk.sunshine_conversations_client.Configuration;
import com.zendesk.sunshine_conversations_client.Pair;
import com.zendesk.sunshine_conversations_client.model.Page;
import com.zendesk.sunshine_conversations_client.model.ParticipantJoinBody;
import com.zendesk.sunshine_conversations_client.model.ParticipantLeaveBody;
import com.zendesk.sunshine_conversations_client.model.ParticipantListResponse;
import com.zendesk.sunshine_conversations_client.model.ParticipantResponse;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;

public class ParticipantsApi {
    private ApiClient apiClient;

    public ParticipantsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ParticipantsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ParticipantResponse joinConversation(ParticipantJoinBody participantJoinBody, String appId, String conversationId) throws ApiException {
        ParticipantJoinBody localVarPostBody = participantJoinBody;
        if (participantJoinBody == null) {
            throw new ApiException(400, "Missing the required parameter 'participantJoinBody' when calling joinConversation");
        }
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling joinConversation");
        }
        if (conversationId == null) {
            throw new ApiException(400, "Missing the required parameter 'conversationId' when calling joinConversation");
        }
        String localVarPath = "/v2/apps/{appId}/conversations/{conversationId}/join".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{conversationId\\}", this.apiClient.escapeString(conversationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<ParticipantResponse> localVarReturnType = new GenericType<ParticipantResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Object leaveConversation(ParticipantLeaveBody participantLeaveBody, String appId, String conversationId) throws ApiException {
        ParticipantLeaveBody localVarPostBody = participantLeaveBody;
        if (participantLeaveBody == null) {
            throw new ApiException(400, "Missing the required parameter 'participantLeaveBody' when calling leaveConversation");
        }
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling leaveConversation");
        }
        if (conversationId == null) {
            throw new ApiException(400, "Missing the required parameter 'conversationId' when calling leaveConversation");
        }
        String localVarPath = "/v2/apps/{appId}/conversations/{conversationId}/leave".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{conversationId\\}", this.apiClient.escapeString(conversationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ParticipantListResponse listParticipants(String appId, String conversationId, Page page) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling listParticipants");
        }
        if (conversationId == null) {
            throw new ApiException(400, "Missing the required parameter 'conversationId' when calling listParticipants");
        }
        String localVarPath = "/v2/apps/{appId}/conversations/{conversationId}/participants".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{conversationId\\}", this.apiClient.escapeString(conversationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page", page));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<ParticipantListResponse> localVarReturnType = new GenericType<ParticipantListResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ParticipantResponse joinConversation(String bearerToken, ParticipantJoinBody participantJoinBody, String appId, String conversationId) throws ApiException {
        ParticipantJoinBody localVarPostBody = participantJoinBody;
        if (participantJoinBody == null) {
            throw new ApiException(400, "Missing the required parameter 'participantJoinBody' when calling joinConversation");
        }
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling joinConversation");
        }
        if (conversationId == null) {
            throw new ApiException(400, "Missing the required parameter 'conversationId' when calling joinConversation");
        }
        String localVarPath = "/v2/apps/{appId}/conversations/{conversationId}/join".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{conversationId\\}", this.apiClient.escapeString(conversationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Authorization", "Bearer " + bearerToken);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<ParticipantResponse> localVarReturnType = new GenericType<ParticipantResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Object leaveConversation(String bearerToken, ParticipantLeaveBody participantLeaveBody, String appId, String conversationId) throws ApiException {
        ParticipantLeaveBody localVarPostBody = participantLeaveBody;
        if (participantLeaveBody == null) {
            throw new ApiException(400, "Missing the required parameter 'participantLeaveBody' when calling leaveConversation");
        }
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling leaveConversation");
        }
        if (conversationId == null) {
            throw new ApiException(400, "Missing the required parameter 'conversationId' when calling leaveConversation");
        }
        String localVarPath = "/v2/apps/{appId}/conversations/{conversationId}/leave".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{conversationId\\}", this.apiClient.escapeString(conversationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Authorization", "Bearer " + bearerToken);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ParticipantListResponse listParticipants(String bearerToken, String appId, String conversationId, Page page) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling listParticipants");
        }
        if (conversationId == null) {
            throw new ApiException(400, "Missing the required parameter 'conversationId' when calling listParticipants");
        }
        String localVarPath = "/v2/apps/{appId}/conversations/{conversationId}/participants".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{conversationId\\}", this.apiClient.escapeString(conversationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page", page));
        localVarHeaderParams.put("Authorization", "Bearer " + bearerToken);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<ParticipantListResponse> localVarReturnType = new GenericType<ParticipantListResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

