/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.Client;
import com.zendesk.sunshine_conversations_client.model.Links;
import com.zendesk.sunshine_conversations_client.model.Meta;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"clients", "meta", "links"})
public class ClientListResponse {
    public static final String JSON_PROPERTY_CLIENTS = "clients";
    private List<Client> clients = null;
    public static final String JSON_PROPERTY_META = "meta";
    private Meta meta;
    public static final String JSON_PROPERTY_LINKS = "links";
    private Links links;

    public ClientListResponse clients(List<Client> clients) {
        this.clients = clients;
        return this;
    }

    public ClientListResponse addClientsItem(Client clientsItem) {
        if (this.clients == null) {
            this.clients = new ArrayList<Client>();
        }
        this.clients.add(clientsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of returned clients.")
    @JsonProperty(value="clients")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Client> getClients() {
        return this.clients;
    }

    public void setClients(List<Client> clients) {
        this.clients = clients;
    }

    public ClientListResponse meta(Meta meta) {
        this.meta = meta;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="meta")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Meta getMeta() {
        return this.meta;
    }

    public void setMeta(Meta meta) {
        this.meta = meta;
    }

    public ClientListResponse links(Links links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Links getLinks() {
        return this.links;
    }

    public void setLinks(Links links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientListResponse clientListResponse = (ClientListResponse)o;
        return Objects.equals(this.clients, clientListResponse.clients) && Objects.equals(this.meta, clientListResponse.meta) && Objects.equals(this.links, clientListResponse.links);
    }

    public int hashCode() {
        return Objects.hash(this.clients, this.meta, this.links);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ClientListResponse {\n");
        sb.append("    clients: ").append(this.toIndentedString(this.clients)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

