/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.QuotedMessage;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;

@JsonPropertyOrder(value={"type", "externalMessageId"})
public class QuotedMessageExternalMessageId
implements QuotedMessage {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type = "externalMessageId";
    public static final String JSON_PROPERTY_EXTERNAL_MESSAGE_ID = "externalMessageId";
    private String externalMessageId;

    public QuotedMessageExternalMessageId type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @ApiModelProperty(required=true, value="The type of quotedMessage - `externalMessageId` if no Sunshine Conversations message matched the quoted message.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public QuotedMessageExternalMessageId externalMessageId(String externalMessageId) {
        this.externalMessageId = externalMessageId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The external message Id of the quoted message.")
    @JsonProperty(value="externalMessageId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalMessageId() {
        return this.externalMessageId;
    }

    public void setExternalMessageId(String externalMessageId) {
        this.externalMessageId = externalMessageId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuotedMessageExternalMessageId quotedMessageExternalMessageId = (QuotedMessageExternalMessageId)o;
        return Objects.equals(this.type, quotedMessageExternalMessageId.type) && Objects.equals(this.externalMessageId, quotedMessageExternalMessageId.externalMessageId);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.externalMessageId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QuotedMessageExternalMessageId {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    externalMessageId: ").append(this.toIndentedString(this.externalMessageId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

