/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.Action;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"type", "text", "payload", "metadata", "iconUrl"})
public class Reply
implements Action {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_TEXT = "text";
    private String text;
    public static final String JSON_PROPERTY_PAYLOAD = "payload";
    private String payload;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private JsonNullable<Map<String, Object>> metadata = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ICON_URL = "iconUrl";
    private String iconUrl;

    public Reply type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @ApiModelProperty(required=true, value="The type of action.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Reply text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(required=true, value="The button text. We recommend a non-empty value because some channels may not support empty ones. Text longer than 20 characters will be truncated on Facebook Messenger, and longer than 40 characters will be truncated on Web Messenger, iOS, and Android.")
    @JsonProperty(value="text")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Reply payload(String payload) {
        this.payload = payload;
        return this;
    }

    @ApiModelProperty(required=true, value="A string payload to help you identify the action context. Used when posting the reply. You can also use metadata for more complex needs.")
    @JsonProperty(value="payload")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public Reply metadata(Map<String, Object> metadata) {
        this.metadata = JsonNullable.of(metadata);
        return this;
    }

    public Reply putMetadataItem(String key, Object metadataItem) {
        if (this.metadata == null || !this.metadata.isPresent()) {
            this.metadata = JsonNullable.of(new HashMap());
        }
        try {
            ((Map)this.metadata.get()).put(key, metadataItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"lang\":\"en-ca\"}", value="Flat object containing custom properties. Strings, numbers and booleans  are the only supported format that can be passed to metadata. The metadata is limited to 4KB in size. ")
    @JsonIgnore
    public Map<String, Object> getMetadata() {
        return (Map)this.metadata.orElse(null);
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Map<String, Object>> getMetadata_JsonNullable() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata_JsonNullable(JsonNullable<Map<String, Object>> metadata) {
        this.metadata = metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = JsonNullable.of(metadata);
    }

    public Reply iconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An icon to render next to the reply option.")
    @JsonProperty(value="iconUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIconUrl() {
        return this.iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Reply reply = (Reply)o;
        return Objects.equals(this.type, reply.type) && Objects.equals(this.text, reply.text) && Objects.equals(this.payload, reply.payload) && Objects.equals(this.metadata, reply.metadata) && Objects.equals(this.iconUrl, reply.iconUrl);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.text, this.payload, this.metadata, this.iconUrl);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Reply {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    payload: ").append(this.toIndentedString(this.payload)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    iconUrl: ").append(this.toIndentedString(this.iconUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

