/*
 * Sunshine Conversations API
 *
 * The version of the OpenAPI document: 15.3.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.zendesk.sunshine_conversations_client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.zendesk.sunshine_conversations_client.model.Identity;
import com.zendesk.sunshine_conversations_client.model.Profile;
import com.zendesk.sunshine_conversations_client.model.UserAllOf;
import com.zendesk.sunshine_conversations_client.model.UserTruncated;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * User
 */
@JsonPropertyOrder({
  User.JSON_PROPERTY_ID,
  User.JSON_PROPERTY_EXTERNAL_ID,
  User.JSON_PROPERTY_ZENDESK_ID,
  User.JSON_PROPERTY_SIGNED_UP_AT,
  User.JSON_PROPERTY_TO_BE_RETAINED,
  User.JSON_PROPERTY_PROFILE,
  User.JSON_PROPERTY_METADATA,
  User.JSON_PROPERTY_IDENTITIES,
  User.JSON_PROPERTY_AUTHENTICATED
})

public class User {
  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_EXTERNAL_ID = "externalId";
  private JsonNullable<String> externalId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ZENDESK_ID = "zendeskId";
  private JsonNullable<String> zendeskId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_SIGNED_UP_AT = "signedUpAt";
  private String signedUpAt = null;

  public static final String JSON_PROPERTY_TO_BE_RETAINED = "toBeRetained";
  private Boolean toBeRetained = null;

  public static final String JSON_PROPERTY_PROFILE = "profile";
  private Profile profile = null;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private Map metadata = null;

  public static final String JSON_PROPERTY_IDENTITIES = "identities";
  private List<Identity> identities = null;

  public static final String JSON_PROPERTY_AUTHENTICATED = "authenticated";
  private Boolean authenticated;


  public User id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * The unique ID of the user.
   * @return id
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(example = "7494535bff5cef41a15be74d", value = "The unique ID of the user.")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  public void setId(String id) {
    this.id = id;
  }


  public User externalId(String externalId) {
    this.externalId = JsonNullable.<String>of(externalId);
    
    return this;
  }

   /**
   * An optional ID that can also be used to retrieve the user. 
   * @return externalId
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(example = "your-own-id", value = "An optional ID that can also be used to retrieve the user. ")
  @JsonIgnore

  public String getExternalId() {
        return externalId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_EXTERNAL_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getExternalId_JsonNullable() {
    return externalId;
  }
  
  @JsonProperty(JSON_PROPERTY_EXTERNAL_ID)
  public void setExternalId_JsonNullable(JsonNullable<String> externalId) {
    this.externalId = externalId;
  }

  public void setExternalId(String externalId) {
    this.externalId = JsonNullable.<String>of(externalId);
  }


  public User zendeskId(String zendeskId) {
    this.zendeskId = JsonNullable.<String>of(zendeskId);
    
    return this;
  }

   /**
   * The ID that links a messaging user to its core Zendesk user counterpart. This ID can be used to fetch the core user record via the Zendesk Support API. 
   * @return zendeskId
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(example = "30045042291606", value = "The ID that links a messaging user to its core Zendesk user counterpart. This ID can be used to fetch the core user record via the Zendesk Support API. ")
  @JsonIgnore

  public String getZendeskId() {
        return zendeskId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ZENDESK_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getZendeskId_JsonNullable() {
    return zendeskId;
  }
  
  @JsonProperty(JSON_PROPERTY_ZENDESK_ID)
  public void setZendeskId_JsonNullable(JsonNullable<String> zendeskId) {
    this.zendeskId = zendeskId;
  }

  public void setZendeskId(String zendeskId) {
    this.zendeskId = JsonNullable.<String>of(zendeskId);
  }


  public User signedUpAt(String signedUpAt) {
    
    this.signedUpAt = signedUpAt;
    return this;
  }

   /**
   * Get signedUpAt
   * @return signedUpAt
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SIGNED_UP_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSignedUpAt() {
    return signedUpAt;
  }


  public void setSignedUpAt(String signedUpAt) {
    this.signedUpAt = signedUpAt;
  }


  public User toBeRetained(Boolean toBeRetained) {
    
    this.toBeRetained = toBeRetained;
    return this;
  }

   /**
   * Get toBeRetained
   * @return toBeRetained
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TO_BE_RETAINED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getToBeRetained() {
    return toBeRetained;
  }


  public void setToBeRetained(Boolean toBeRetained) {
    this.toBeRetained = toBeRetained;
  }


  public User profile(Profile profile) {
    
    this.profile = profile;
    return this;
  }

   /**
   * Get profile
   * @return profile
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PROFILE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Profile getProfile() {
    return profile;
  }


  public void setProfile(Profile profile) {
    this.profile = profile;
  }


  public User metadata(Map metadata) {
    
    this.metadata = metadata;
    return this;
  }

   /**
   * Get metadata
   * @return metadata
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map getMetadata() {
    return metadata;
  }


  public void setMetadata(Map metadata) {
    this.metadata = metadata;
  }


   /**
   * The user&#39;s connected identities.
   * @return identities
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(value = "The user's connected identities.")
  @JsonProperty(JSON_PROPERTY_IDENTITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Identity> getIdentities() {
    return identities;
  }




   /**
   * Whether or not the user has authenticated, either via JWT or via the Help Center
   * @return authenticated
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(value = "Whether or not the user has authenticated, either via JWT or via the Help Center")
  @JsonProperty(JSON_PROPERTY_AUTHENTICATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAuthenticated() {
    return authenticated;
  }




  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    User user = (User) o;
    return Objects.equals(this.id, user.id) &&
        Objects.equals(this.externalId, user.externalId) &&
        Objects.equals(this.zendeskId, user.zendeskId) &&
        Objects.equals(this.signedUpAt, user.signedUpAt) &&
        Objects.equals(this.toBeRetained, user.toBeRetained) &&
        Objects.equals(this.profile, user.profile) &&
        Objects.equals(this.metadata, user.metadata) &&
        Objects.equals(this.identities, user.identities) &&
        Objects.equals(this.authenticated, user.authenticated);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, externalId, zendeskId, signedUpAt, toBeRetained, profile, metadata, identities, authenticated);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class User {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    externalId: ").append(toIndentedString(externalId)).append("\n");
    sb.append("    zendeskId: ").append(toIndentedString(zendeskId)).append("\n");
    sb.append("    signedUpAt: ").append(toIndentedString(signedUpAt)).append("\n");
    sb.append("    toBeRetained: ").append(toIndentedString(toBeRetained)).append("\n");
    sb.append("    profile: ").append(toIndentedString(profile)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    identities: ").append(toIndentedString(identities)).append("\n");
    sb.append("    authenticated: ").append(toIndentedString(authenticated)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

