/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.AppSettings;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"id", "displayName", "settings", "metadata"})
public class App {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private String displayName = null;
    public static final String JSON_PROPERTY_SETTINGS = "settings";
    private AppSettings settings;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private JsonNullable<Map<String, Object>> metadata = JsonNullable.undefined();

    public App id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="5d8cff3cd55b040010928b5b", value="A canonical ID that can be used to retrieve the Sunshine Conversations app.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public App displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="My App", value="The friendly name of the app.")
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public App settings(AppSettings settings) {
        this.settings = settings;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="settings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AppSettings getSettings() {
        return this.settings;
    }

    public void setSettings(AppSettings settings) {
        this.settings = settings;
    }

    public App metadata(Map<String, Object> metadata) {
        this.metadata = JsonNullable.of(metadata);
        return this;
    }

    public App putMetadataItem(String key, Object metadataItem) {
        if (this.metadata == null || !this.metadata.isPresent()) {
            this.metadata = JsonNullable.of(new HashMap());
        }
        try {
            ((Map)this.metadata.get()).put(key, metadataItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"lang\":\"en-ca\"}", value="Flat object containing custom properties. Strings, numbers and booleans  are the only supported format that can be passed to metadata. The metadata is limited to 4KB in size. ")
    @JsonIgnore
    public Map<String, Object> getMetadata() {
        return (Map)this.metadata.orElse(null);
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Map<String, Object>> getMetadata_JsonNullable() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata_JsonNullable(JsonNullable<Map<String, Object>> metadata) {
        this.metadata = metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = JsonNullable.of(metadata);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        App app = (App)o;
        return Objects.equals(this.id, app.id) && Objects.equals(this.displayName, app.displayName) && Objects.equals(this.settings, app.settings) && Objects.equals(this.metadata, app.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.displayName, this.settings, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class App {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    settings: ").append(this.toIndentedString(this.settings)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

