/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"payload", "metadata"})
public class PostbackWebhook {
    public static final String JSON_PROPERTY_PAYLOAD = "payload";
    private String payload;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private JsonNullable<Map<String, Object>> metadata = JsonNullable.undefined();

    public PostbackWebhook payload(String payload) {
        this.payload = payload;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The payload associated with the postback.")
    @JsonProperty(value="payload")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public PostbackWebhook metadata(Map<String, Object> metadata) {
        this.metadata = JsonNullable.of(metadata);
        return this;
    }

    public PostbackWebhook putMetadataItem(String key, Object metadataItem) {
        if (this.metadata == null || !this.metadata.isPresent()) {
            this.metadata = JsonNullable.of(new HashMap());
        }
        try {
            ((Map)this.metadata.get()).put(key, metadataItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"lang\":\"en-ca\"}", value="Flat object containing custom properties. Strings, numbers and booleans  are the only supported format that can be passed to metadata. The metadata is limited to 4KB in size. ")
    @JsonIgnore
    public Map<String, Object> getMetadata() {
        return (Map)this.metadata.orElse(null);
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Map<String, Object>> getMetadata_JsonNullable() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata_JsonNullable(JsonNullable<Map<String, Object>> metadata) {
        this.metadata = metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = JsonNullable.of(metadata);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostbackWebhook postbackWebhook = (PostbackWebhook)o;
        return Objects.equals(this.payload, postbackWebhook.payload) && Objects.equals(this.metadata, postbackWebhook.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.payload, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostbackWebhook {\n");
        sb.append("    payload: ").append(this.toIndentedString(this.payload)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

