/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"name", "integrationId", "integrationType", "deliverStandbyEvents", "nextSwitchboardIntegrationId", "messageHistoryCount"})
public class SwitchboardIntegrationUpdateBody {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_INTEGRATION_ID = "integrationId";
    private String integrationId = null;
    public static final String JSON_PROPERTY_INTEGRATION_TYPE = "integrationType";
    private String integrationType = null;
    public static final String JSON_PROPERTY_DELIVER_STANDBY_EVENTS = "deliverStandbyEvents";
    private Boolean deliverStandbyEvents;
    public static final String JSON_PROPERTY_NEXT_SWITCHBOARD_INTEGRATION_ID = "nextSwitchboardIntegrationId";
    private JsonNullable<String> nextSwitchboardIntegrationId = JsonNullable.undefined();
    public static final String JSON_PROPERTY_MESSAGE_HISTORY_COUNT = "messageHistoryCount";
    private JsonNullable<Integer> messageHistoryCount = JsonNullable.undefined();

    public SwitchboardIntegrationUpdateBody name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="bot", value="Identifier for use in control transfer protocols. Restricted to alphanumeric characters, `-` and `_`.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SwitchboardIntegrationUpdateBody integrationId(String integrationId) {
        this.integrationId = integrationId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the integration to link to the switchboard integration. Must be used when linking a custom integration. Can't provide both `integrationId` and `integrationType`.")
    @JsonProperty(value="integrationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIntegrationId() {
        return this.integrationId;
    }

    public void setIntegrationId(String integrationId) {
        this.integrationId = integrationId;
    }

    public SwitchboardIntegrationUpdateBody integrationType(String integrationType) {
        this.integrationType = integrationType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of the integration to link to the switchboard integration. Must be used when linking an OAuth integration. Can't provide both `integrationId` and `integrationType`.")
    @JsonProperty(value="integrationType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIntegrationType() {
        return this.integrationType;
    }

    public void setIntegrationType(String integrationType) {
        this.integrationType = integrationType;
    }

    public SwitchboardIntegrationUpdateBody deliverStandbyEvents(Boolean deliverStandbyEvents) {
        this.deliverStandbyEvents = deliverStandbyEvents;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Setting to determine if webhooks should be sent when the switchboard integration is not in control of a conversation (standby status)")
    @JsonProperty(value="deliverStandbyEvents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getDeliverStandbyEvents() {
        return this.deliverStandbyEvents;
    }

    public void setDeliverStandbyEvents(Boolean deliverStandbyEvents) {
        this.deliverStandbyEvents = deliverStandbyEvents;
    }

    public SwitchboardIntegrationUpdateBody nextSwitchboardIntegrationId(String nextSwitchboardIntegrationId) {
        this.nextSwitchboardIntegrationId = JsonNullable.of((Object)nextSwitchboardIntegrationId);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="5ef21b86e933b7355c11c606", value="The switchboard integration id to which control of a conversation is passed / offered by default.")
    @JsonIgnore
    public String getNextSwitchboardIntegrationId() {
        return (String)this.nextSwitchboardIntegrationId.orElse(null);
    }

    @JsonProperty(value="nextSwitchboardIntegrationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getNextSwitchboardIntegrationId_JsonNullable() {
        return this.nextSwitchboardIntegrationId;
    }

    @JsonProperty(value="nextSwitchboardIntegrationId")
    public void setNextSwitchboardIntegrationId_JsonNullable(JsonNullable<String> nextSwitchboardIntegrationId) {
        this.nextSwitchboardIntegrationId = nextSwitchboardIntegrationId;
    }

    public void setNextSwitchboardIntegrationId(String nextSwitchboardIntegrationId) {
        this.nextSwitchboardIntegrationId = JsonNullable.of((Object)nextSwitchboardIntegrationId);
    }

    public SwitchboardIntegrationUpdateBody messageHistoryCount(Integer messageHistoryCount) {
        this.messageHistoryCount = JsonNullable.of((Object)messageHistoryCount);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="5", value="Number of messages to include in the message history context.")
    @JsonIgnore
    public Integer getMessageHistoryCount() {
        return (Integer)this.messageHistoryCount.orElse(null);
    }

    @JsonProperty(value="messageHistoryCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getMessageHistoryCount_JsonNullable() {
        return this.messageHistoryCount;
    }

    @JsonProperty(value="messageHistoryCount")
    public void setMessageHistoryCount_JsonNullable(JsonNullable<Integer> messageHistoryCount) {
        this.messageHistoryCount = messageHistoryCount;
    }

    public void setMessageHistoryCount(Integer messageHistoryCount) {
        this.messageHistoryCount = JsonNullable.of((Object)messageHistoryCount);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SwitchboardIntegrationUpdateBody switchboardIntegrationUpdateBody = (SwitchboardIntegrationUpdateBody)o;
        return Objects.equals(this.name, switchboardIntegrationUpdateBody.name) && Objects.equals(this.integrationId, switchboardIntegrationUpdateBody.integrationId) && Objects.equals(this.integrationType, switchboardIntegrationUpdateBody.integrationType) && Objects.equals(this.deliverStandbyEvents, switchboardIntegrationUpdateBody.deliverStandbyEvents) && Objects.equals(this.nextSwitchboardIntegrationId, switchboardIntegrationUpdateBody.nextSwitchboardIntegrationId) && Objects.equals(this.messageHistoryCount, switchboardIntegrationUpdateBody.messageHistoryCount);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.integrationId, this.integrationType, this.deliverStandbyEvents, this.nextSwitchboardIntegrationId, this.messageHistoryCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SwitchboardIntegrationUpdateBody {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    integrationId: ").append(this.toIndentedString(this.integrationId)).append("\n");
        sb.append("    integrationType: ").append(this.toIndentedString(this.integrationType)).append("\n");
        sb.append("    deliverStandbyEvents: ").append(this.toIndentedString(this.deliverStandbyEvents)).append("\n");
        sb.append("    nextSwitchboardIntegrationId: ").append(this.toIndentedString(this.nextSwitchboardIntegrationId)).append("\n");
        sb.append("    messageHistoryCount: ").append(this.toIndentedString(this.messageHistoryCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

