/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.zendesk.sunshine_conversations_client.model.Android;
import com.zendesk.sunshine_conversations_client.model.Apple;
import com.zendesk.sunshine_conversations_client.model.Custom;
import com.zendesk.sunshine_conversations_client.model.DefaultResponderDefaultResponder;
import com.zendesk.sunshine_conversations_client.model.Instagram;
import com.zendesk.sunshine_conversations_client.model.Integration;
import com.zendesk.sunshine_conversations_client.model.Ios;
import com.zendesk.sunshine_conversations_client.model.Line;
import com.zendesk.sunshine_conversations_client.model.Mailgun;
import com.zendesk.sunshine_conversations_client.model.Messagebird;
import com.zendesk.sunshine_conversations_client.model.Messenger;
import com.zendesk.sunshine_conversations_client.model.Twilio;
import com.zendesk.sunshine_conversations_client.model.Twitter;
import com.zendesk.sunshine_conversations_client.model.Unity;
import com.zendesk.sunshine_conversations_client.model.Viber;
import com.zendesk.sunshine_conversations_client.model.Web;
import com.zendesk.sunshine_conversations_client.model.Whatsapp;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"type", "token", "username", "botId", "defaultResponderId", "defaultResponder"})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=Android.class, name="android"), @JsonSubTypes.Type(value=Apple.class, name="apple"), @JsonSubTypes.Type(value=Custom.class, name="custom"), @JsonSubTypes.Type(value=Instagram.class, name="instagram"), @JsonSubTypes.Type(value=Ios.class, name="ios"), @JsonSubTypes.Type(value=Line.class, name="line"), @JsonSubTypes.Type(value=Mailgun.class, name="mailgun"), @JsonSubTypes.Type(value=Messagebird.class, name="messagebird"), @JsonSubTypes.Type(value=Messenger.class, name="messenger"), @JsonSubTypes.Type(value=Telegram.class, name="telegram"), @JsonSubTypes.Type(value=Twilio.class, name="twilio"), @JsonSubTypes.Type(value=Twitter.class, name="twitter"), @JsonSubTypes.Type(value=Unity.class, name="unity"), @JsonSubTypes.Type(value=Viber.class, name="viber"), @JsonSubTypes.Type(value=Web.class, name="web"), @JsonSubTypes.Type(value=Whatsapp.class, name="whatsapp")})
public class Telegram
extends Integration {
    public static final String JSON_PROPERTY_TYPE = "type";
    protected String type = "telegram";
    public static final String JSON_PROPERTY_TOKEN = "token";
    private String token;
    public static final String JSON_PROPERTY_USERNAME = "username";
    private String username;
    public static final String JSON_PROPERTY_BOT_ID = "botId";
    private String botId;
    public static final String JSON_PROPERTY_DEFAULT_RESPONDER_ID = "defaultResponderId";
    private JsonNullable<String> defaultResponderId = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DEFAULT_RESPONDER = "defaultResponder";
    private JsonNullable<DefaultResponderDefaultResponder> defaultResponder = JsonNullable.undefined();

    @Override
    public Telegram type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @Nullable
    @ApiModelProperty(value="To configure a Telegram integration, acquire the required information from the user and call the Create Integration endpoint. ")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public Telegram token(String token) {
        this.token = token;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="192033615:AAEuee2FS2JYKWfDlTulfygjaIGJi4s", required=true, value="Telegram Bot Token.")
    @JsonProperty(value="token")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    @Nullable
    @ApiModelProperty(value="Username of the botId")
    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUsername() {
        return this.username;
    }

    @Nullable
    @ApiModelProperty(value="A human-friendly name used to identify the integration.")
    @JsonProperty(value="botId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBotId() {
        return this.botId;
    }

    public Telegram defaultResponderId(String defaultResponderId) {
        this.defaultResponderId = JsonNullable.of((Object)defaultResponderId);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The default responder ID for the integration. This is the ID of the responder that will be used to send messages to the user. For more information, refer to <a href=\"https://docs.smooch.io/guide/switchboard/#per-channel-default-responder\">Per-channel default responder</a> guide. ")
    @JsonIgnore
    public String getDefaultResponderId() {
        return (String)this.defaultResponderId.orElse(null);
    }

    @JsonProperty(value="defaultResponderId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDefaultResponderId_JsonNullable() {
        return this.defaultResponderId;
    }

    @JsonProperty(value="defaultResponderId")
    public void setDefaultResponderId_JsonNullable(JsonNullable<String> defaultResponderId) {
        this.defaultResponderId = defaultResponderId;
    }

    public void setDefaultResponderId(String defaultResponderId) {
        this.defaultResponderId = JsonNullable.of((Object)defaultResponderId);
    }

    public Telegram defaultResponder(DefaultResponderDefaultResponder defaultResponder) {
        this.defaultResponder = JsonNullable.of((Object)defaultResponder);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public DefaultResponderDefaultResponder getDefaultResponder() {
        return (DefaultResponderDefaultResponder)this.defaultResponder.orElse(null);
    }

    @JsonProperty(value="defaultResponder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<DefaultResponderDefaultResponder> getDefaultResponder_JsonNullable() {
        return this.defaultResponder;
    }

    @JsonProperty(value="defaultResponder")
    public void setDefaultResponder_JsonNullable(JsonNullable<DefaultResponderDefaultResponder> defaultResponder) {
        this.defaultResponder = defaultResponder;
    }

    public void setDefaultResponder(DefaultResponderDefaultResponder defaultResponder) {
        this.defaultResponder = JsonNullable.of((Object)defaultResponder);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Telegram telegram = (Telegram)o;
        return Objects.equals(this.type, telegram.type) && Objects.equals(this.token, telegram.token) && Objects.equals(this.username, telegram.username) && Objects.equals(this.botId, telegram.botId) && Objects.equals(this.defaultResponderId, telegram.defaultResponderId) && Objects.equals(this.defaultResponder, telegram.defaultResponder) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type, this.token, this.username, this.botId, this.defaultResponderId, this.defaultResponder, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Telegram {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("    botId: ").append(this.toIndentedString(this.botId)).append("\n");
        sb.append("    defaultResponderId: ").append(this.toIndentedString(this.defaultResponderId)).append("\n");
        sb.append("    defaultResponder: ").append(this.toIndentedString(this.defaultResponder)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

