/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;

@JsonPropertyOrder(value={"type", "token", "username", "botId"})
public class TelegramAllOf {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type = "telegram";
    public static final String JSON_PROPERTY_TOKEN = "token";
    private String token;
    public static final String JSON_PROPERTY_USERNAME = "username";
    private String username;
    public static final String JSON_PROPERTY_BOT_ID = "botId";
    private String botId;

    public TelegramAllOf type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="To configure a Telegram integration, acquire the required information from the user and call the Create Integration endpoint. ")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public TelegramAllOf token(String token) {
        this.token = token;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="192033615:AAEuee2FS2JYKWfDlTulfygjaIGJi4s", required=true, value="Telegram Bot Token.")
    @JsonProperty(value="token")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    @Nullable
    @ApiModelProperty(value="Username of the botId")
    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUsername() {
        return this.username;
    }

    @Nullable
    @ApiModelProperty(value="A human-friendly name used to identify the integration.")
    @JsonProperty(value="botId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBotId() {
        return this.botId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TelegramAllOf telegramAllOf = (TelegramAllOf)o;
        return Objects.equals(this.type, telegramAllOf.type) && Objects.equals(this.token, telegramAllOf.token) && Objects.equals(this.username, telegramAllOf.username) && Objects.equals(this.botId, telegramAllOf.botId);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.token, this.username, this.botId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TelegramAllOf {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("    botId: ").append(this.toIndentedString(this.botId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

