/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.Identity;
import com.zendesk.sunshine_conversations_client.model.Profile;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"id", "externalId", "zendeskId", "signedUpAt", "toBeRetained", "profile", "metadata", "identities", "authenticated"})
public class User {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_EXTERNAL_ID = "externalId";
    private JsonNullable<String> externalId = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ZENDESK_ID = "zendeskId";
    private JsonNullable<String> zendeskId = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SIGNED_UP_AT = "signedUpAt";
    private String signedUpAt = null;
    public static final String JSON_PROPERTY_TO_BE_RETAINED = "toBeRetained";
    private Boolean toBeRetained = null;
    public static final String JSON_PROPERTY_PROFILE = "profile";
    private Profile profile = null;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private Map metadata = null;
    public static final String JSON_PROPERTY_IDENTITIES = "identities";
    private List<Identity> identities = null;
    public static final String JSON_PROPERTY_AUTHENTICATED = "authenticated";
    private Boolean authenticated;

    public User id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="7494535bff5cef41a15be74d", value="The unique ID of the user.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public User externalId(String externalId) {
        this.externalId = JsonNullable.of((Object)externalId);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="your-own-id", value="An optional ID that can also be used to retrieve the user. ")
    @JsonIgnore
    public String getExternalId() {
        return (String)this.externalId.orElse(null);
    }

    @JsonProperty(value="externalId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getExternalId_JsonNullable() {
        return this.externalId;
    }

    @JsonProperty(value="externalId")
    public void setExternalId_JsonNullable(JsonNullable<String> externalId) {
        this.externalId = externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = JsonNullable.of((Object)externalId);
    }

    public User zendeskId(String zendeskId) {
        this.zendeskId = JsonNullable.of((Object)zendeskId);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="30045042291606", value="The ID that links a messaging user to its core Zendesk user counterpart. This ID can be used to fetch the core user record via the Zendesk Support API. ")
    @JsonIgnore
    public String getZendeskId() {
        return (String)this.zendeskId.orElse(null);
    }

    @JsonProperty(value="zendeskId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getZendeskId_JsonNullable() {
        return this.zendeskId;
    }

    @JsonProperty(value="zendeskId")
    public void setZendeskId_JsonNullable(JsonNullable<String> zendeskId) {
        this.zendeskId = zendeskId;
    }

    public void setZendeskId(String zendeskId) {
        this.zendeskId = JsonNullable.of((Object)zendeskId);
    }

    public User signedUpAt(String signedUpAt) {
        this.signedUpAt = signedUpAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="signedUpAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSignedUpAt() {
        return this.signedUpAt;
    }

    public void setSignedUpAt(String signedUpAt) {
        this.signedUpAt = signedUpAt;
    }

    public User toBeRetained(Boolean toBeRetained) {
        this.toBeRetained = toBeRetained;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="toBeRetained")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getToBeRetained() {
        return this.toBeRetained;
    }

    public void setToBeRetained(Boolean toBeRetained) {
        this.toBeRetained = toBeRetained;
    }

    public User profile(Profile profile) {
        this.profile = profile;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="profile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Profile getProfile() {
        return this.profile;
    }

    public void setProfile(Profile profile) {
        this.profile = profile;
    }

    public User metadata(Map metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map metadata) {
        this.metadata = metadata;
    }

    @Nullable
    @ApiModelProperty(value="The user's connected identities.")
    @JsonProperty(value="identities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Identity> getIdentities() {
        return this.identities;
    }

    @Nullable
    @ApiModelProperty(value="Whether or not the user has authenticated, either via JWT or via the Help Center")
    @JsonProperty(value="authenticated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAuthenticated() {
        return this.authenticated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return Objects.equals(this.id, user.id) && Objects.equals(this.externalId, user.externalId) && Objects.equals(this.zendeskId, user.zendeskId) && Objects.equals(this.signedUpAt, user.signedUpAt) && Objects.equals(this.toBeRetained, user.toBeRetained) && Objects.equals(this.profile, user.profile) && Objects.equals(this.metadata, user.metadata) && Objects.equals(this.identities, user.identities) && Objects.equals(this.authenticated, user.authenticated);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.externalId, this.zendeskId, this.signedUpAt, this.toBeRetained, this.profile, this.metadata, this.identities, this.authenticated);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class User {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    zendeskId: ").append(this.toIndentedString(this.zendeskId)).append("\n");
        sb.append("    signedUpAt: ").append(this.toIndentedString(this.signedUpAt)).append("\n");
        sb.append("    toBeRetained: ").append(this.toIndentedString(this.toBeRetained)).append("\n");
        sb.append("    profile: ").append(this.toIndentedString(this.profile)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    identities: ").append(this.toIndentedString(this.identities)).append("\n");
        sb.append("    authenticated: ").append(this.toIndentedString(this.authenticated)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

