/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.zendesk.sunshine_conversations_client.model.UserMergeEventAllOfPayloadMergedClients;
import com.zendesk.sunshine_conversations_client.model.UserMergeEventAllOfPayloadMergedConversations;
import com.zendesk.sunshine_conversations_client.model.UserMergeEventAllOfPayloadMergedUsers;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="The payload of the event. The contents of this object depend on the type of event.")
@JsonPropertyOrder(value={"mergedUsers", "mergedConversations", "mergedClients", "discardedMetadata", "reason"})
public class UserMergeEventAllOfPayload {
    public static final String JSON_PROPERTY_MERGED_USERS = "mergedUsers";
    private UserMergeEventAllOfPayloadMergedUsers mergedUsers;
    public static final String JSON_PROPERTY_MERGED_CONVERSATIONS = "mergedConversations";
    private JsonNullable<UserMergeEventAllOfPayloadMergedConversations> mergedConversations = JsonNullable.undefined();
    public static final String JSON_PROPERTY_MERGED_CLIENTS = "mergedClients";
    private JsonNullable<UserMergeEventAllOfPayloadMergedClients> mergedClients = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DISCARDED_METADATA = "discardedMetadata";
    private JsonNullable<Map> discardedMetadata = JsonNullable.of(null);
    public static final String JSON_PROPERTY_REASON = "reason";
    private ReasonEnum reason;

    public UserMergeEventAllOfPayload mergedUsers(UserMergeEventAllOfPayloadMergedUsers mergedUsers) {
        this.mergedUsers = mergedUsers;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="mergedUsers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UserMergeEventAllOfPayloadMergedUsers getMergedUsers() {
        return this.mergedUsers;
    }

    public void setMergedUsers(UserMergeEventAllOfPayloadMergedUsers mergedUsers) {
        this.mergedUsers = mergedUsers;
    }

    public UserMergeEventAllOfPayload mergedConversations(UserMergeEventAllOfPayloadMergedConversations mergedConversations) {
        this.mergedConversations = JsonNullable.of((Object)mergedConversations);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public UserMergeEventAllOfPayloadMergedConversations getMergedConversations() {
        return (UserMergeEventAllOfPayloadMergedConversations)this.mergedConversations.orElse(null);
    }

    @JsonProperty(value="mergedConversations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<UserMergeEventAllOfPayloadMergedConversations> getMergedConversations_JsonNullable() {
        return this.mergedConversations;
    }

    @JsonProperty(value="mergedConversations")
    public void setMergedConversations_JsonNullable(JsonNullable<UserMergeEventAllOfPayloadMergedConversations> mergedConversations) {
        this.mergedConversations = mergedConversations;
    }

    public void setMergedConversations(UserMergeEventAllOfPayloadMergedConversations mergedConversations) {
        this.mergedConversations = JsonNullable.of((Object)mergedConversations);
    }

    public UserMergeEventAllOfPayload mergedClients(UserMergeEventAllOfPayloadMergedClients mergedClients) {
        this.mergedClients = JsonNullable.of((Object)mergedClients);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public UserMergeEventAllOfPayloadMergedClients getMergedClients() {
        return (UserMergeEventAllOfPayloadMergedClients)this.mergedClients.orElse(null);
    }

    @JsonProperty(value="mergedClients")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<UserMergeEventAllOfPayloadMergedClients> getMergedClients_JsonNullable() {
        return this.mergedClients;
    }

    @JsonProperty(value="mergedClients")
    public void setMergedClients_JsonNullable(JsonNullable<UserMergeEventAllOfPayloadMergedClients> mergedClients) {
        this.mergedClients = mergedClients;
    }

    public void setMergedClients(UserMergeEventAllOfPayloadMergedClients mergedClients) {
        this.mergedClients = JsonNullable.of((Object)mergedClients);
    }

    public UserMergeEventAllOfPayload discardedMetadata(Map discardedMetadata) {
        this.discardedMetadata = JsonNullable.of((Object)discardedMetadata);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A flat object with the set of metadata properties that were discarded when merging the two users. This should contain values only if the combined metadata fields exceed the 4KB limit.")
    @JsonIgnore
    public Map getDiscardedMetadata() {
        return (Map)this.discardedMetadata.orElse(null);
    }

    @JsonProperty(value="discardedMetadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Map> getDiscardedMetadata_JsonNullable() {
        return this.discardedMetadata;
    }

    @JsonProperty(value="discardedMetadata")
    public void setDiscardedMetadata_JsonNullable(JsonNullable<Map> discardedMetadata) {
        this.discardedMetadata = discardedMetadata;
    }

    public void setDiscardedMetadata(Map discardedMetadata) {
        this.discardedMetadata = JsonNullable.of((Object)discardedMetadata);
    }

    public UserMergeEventAllOfPayload reason(ReasonEnum reason) {
        this.reason = reason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The reason for which the users merged. * `api` - The users were merged using the API. * `channelLinking` - The users were merged as a result of initiating a channel link. * `sdkLogin` - The users were merged as a result of logging into an SDK device. ")
    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ReasonEnum getReason() {
        return this.reason;
    }

    public void setReason(ReasonEnum reason) {
        this.reason = reason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserMergeEventAllOfPayload userMergeEventAllOfPayload = (UserMergeEventAllOfPayload)o;
        return Objects.equals(this.mergedUsers, userMergeEventAllOfPayload.mergedUsers) && Objects.equals(this.mergedConversations, userMergeEventAllOfPayload.mergedConversations) && Objects.equals(this.mergedClients, userMergeEventAllOfPayload.mergedClients) && Objects.equals(this.discardedMetadata, userMergeEventAllOfPayload.discardedMetadata) && Objects.equals((Object)this.reason, (Object)userMergeEventAllOfPayload.reason);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mergedUsers, this.mergedConversations, this.mergedClients, this.discardedMetadata, this.reason});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserMergeEventAllOfPayload {\n");
        sb.append("    mergedUsers: ").append(this.toIndentedString(this.mergedUsers)).append("\n");
        sb.append("    mergedConversations: ").append(this.toIndentedString(this.mergedConversations)).append("\n");
        sb.append("    mergedClients: ").append(this.toIndentedString(this.mergedClients)).append("\n");
        sb.append("    discardedMetadata: ").append(this.toIndentedString(this.discardedMetadata)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString((Object)this.reason)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ReasonEnum {
        API("api"),
        CHANNELLINKING("channelLinking"),
        SDKLOGIN("sdkLogin");

        private String value;

        private ReasonEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ReasonEnum fromValue(String value) {
            for (ReasonEnum b : ReasonEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

