/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.Client;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;

@ApiModel(description="Contains information about the clients that were merged together as a result of the operation, if applicable. If no clients were merged, this property is omitted.")
@JsonPropertyOrder(value={"surviving", "discarded"})
public class UserMergeEventAllOfPayloadMergedClients {
    public static final String JSON_PROPERTY_SURVIVING = "surviving";
    private Client surviving = null;
    public static final String JSON_PROPERTY_DISCARDED = "discarded";
    private Client discarded = null;

    public UserMergeEventAllOfPayloadMergedClients surviving(Client surviving) {
        this.surviving = surviving;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The client that already existed before the merge started.")
    @JsonProperty(value="surviving")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Client getSurviving() {
        return this.surviving;
    }

    public void setSurviving(Client surviving) {
        this.surviving = surviving;
    }

    public UserMergeEventAllOfPayloadMergedClients discarded(Client discarded) {
        this.discarded = discarded;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The pending client that was discarded during the merge event.")
    @JsonProperty(value="discarded")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Client getDiscarded() {
        return this.discarded;
    }

    public void setDiscarded(Client discarded) {
        this.discarded = discarded;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserMergeEventAllOfPayloadMergedClients userMergeEventAllOfPayloadMergedClients = (UserMergeEventAllOfPayloadMergedClients)o;
        return Objects.equals(this.surviving, userMergeEventAllOfPayloadMergedClients.surviving) && Objects.equals(this.discarded, userMergeEventAllOfPayloadMergedClients.discarded);
    }

    public int hashCode() {
        return Objects.hash(this.surviving, this.discarded);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserMergeEventAllOfPayloadMergedClients {\n");
        sb.append("    surviving: ").append(this.toIndentedString(this.surviving)).append("\n");
        sb.append("    discarded: ").append(this.toIndentedString(this.discarded)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

