/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.Profile;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"signedUpAt", "toBeRetained", "profile", "metadata"})
public class UserUpdateBody {
    public static final String JSON_PROPERTY_SIGNED_UP_AT = "signedUpAt";
    private String signedUpAt = null;
    public static final String JSON_PROPERTY_TO_BE_RETAINED = "toBeRetained";
    private Boolean toBeRetained = null;
    public static final String JSON_PROPERTY_PROFILE = "profile";
    private Profile profile = null;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private JsonNullable<Map<String, Object>> metadata = JsonNullable.undefined();

    public UserUpdateBody signedUpAt(String signedUpAt) {
        this.signedUpAt = signedUpAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="signedUpAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSignedUpAt() {
        return this.signedUpAt;
    }

    public void setSignedUpAt(String signedUpAt) {
        this.signedUpAt = signedUpAt;
    }

    public UserUpdateBody toBeRetained(Boolean toBeRetained) {
        this.toBeRetained = toBeRetained;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="toBeRetained")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getToBeRetained() {
        return this.toBeRetained;
    }

    public void setToBeRetained(Boolean toBeRetained) {
        this.toBeRetained = toBeRetained;
    }

    public UserUpdateBody profile(Profile profile) {
        this.profile = profile;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="profile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Profile getProfile() {
        return this.profile;
    }

    public void setProfile(Profile profile) {
        this.profile = profile;
    }

    public UserUpdateBody metadata(Map<String, Object> metadata) {
        this.metadata = JsonNullable.of(metadata);
        return this;
    }

    public UserUpdateBody putMetadataItem(String key, Object metadataItem) {
        if (this.metadata == null || !this.metadata.isPresent()) {
            this.metadata = JsonNullable.of(new HashMap());
        }
        try {
            ((Map)this.metadata.get()).put(key, metadataItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"lang\":\"en-ca\"}", value="Flat object containing custom properties. Strings, numbers and booleans  are the only supported format that can be passed to metadata. The metadata is limited to 4KB in size. ")
    @JsonIgnore
    public Map<String, Object> getMetadata() {
        return (Map)this.metadata.orElse(null);
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Map<String, Object>> getMetadata_JsonNullable() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata_JsonNullable(JsonNullable<Map<String, Object>> metadata) {
        this.metadata = metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = JsonNullable.of(metadata);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserUpdateBody userUpdateBody = (UserUpdateBody)o;
        return Objects.equals(this.signedUpAt, userUpdateBody.signedUpAt) && Objects.equals(this.toBeRetained, userUpdateBody.toBeRetained) && Objects.equals(this.profile, userUpdateBody.profile) && Objects.equals(this.metadata, userUpdateBody.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.signedUpAt, this.toBeRetained, this.profile, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserUpdateBody {\n");
        sb.append("    signedUpAt: ").append(this.toIndentedString(this.signedUpAt)).append("\n");
        sb.append("    toBeRetained: ").append(this.toIndentedString(this.toBeRetained)).append("\n");
        sb.append("    profile: ").append(this.toIndentedString(this.profile)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

