/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="The exact payload to send to the channel.")
@JsonPropertyOrder(value={"payload", "withCapabilities"})
public class AppleMessageOverridePayload {
    public static final String JSON_PROPERTY_PAYLOAD = "payload";
    private Object payload;
    public static final String JSON_PROPERTY_WITH_CAPABILITIES = "withCapabilities";
    private List<WithCapabilitiesEnum> withCapabilities = null;

    public AppleMessageOverridePayload payload(Object payload) {
        this.payload = payload;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="payload")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getPayload() {
        return this.payload;
    }

    public void setPayload(Object payload) {
        this.payload = payload;
    }

    public AppleMessageOverridePayload withCapabilities(List<WithCapabilitiesEnum> withCapabilities) {
        this.withCapabilities = withCapabilities;
        return this;
    }

    public AppleMessageOverridePayload addWithCapabilitiesItem(WithCapabilitiesEnum withCapabilitiesItem) {
        if (this.withCapabilities == null) {
            this.withCapabilities = new ArrayList<WithCapabilitiesEnum>();
        }
        this.withCapabilities.add(withCapabilitiesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"LIST\"]", value="List of capabilities needed for the override message to be received by the end user.   `LIST` : for list picker; `TIME` : for time picker; `FORM` : for form; `QUICK` : for quick reply; `AUTH2` : for authentication ")
    @JsonProperty(value="withCapabilities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WithCapabilitiesEnum> getWithCapabilities() {
        return this.withCapabilities;
    }

    public void setWithCapabilities(List<WithCapabilitiesEnum> withCapabilities) {
        this.withCapabilities = withCapabilities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppleMessageOverridePayload appleMessageOverridePayload = (AppleMessageOverridePayload)o;
        return Objects.equals(this.payload, appleMessageOverridePayload.payload) && Objects.equals(this.withCapabilities, appleMessageOverridePayload.withCapabilities);
    }

    public int hashCode() {
        return Objects.hash(this.payload, this.withCapabilities);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppleMessageOverridePayload {\n");
        sb.append("    payload: ").append(this.toIndentedString(this.payload)).append("\n");
        sb.append("    withCapabilities: ").append(this.toIndentedString(this.withCapabilities)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum WithCapabilitiesEnum {
        LIST("LIST"),
        TIME("TIME"),
        FORM("FORM"),
        QUICK("QUICK"),
        AUTH2("AUTH2");

        private String value;

        private WithCapabilitiesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static WithCapabilitiesEnum fromValue(String value) {
            for (WithCapabilitiesEnum b : WithCapabilitiesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

