/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="The default responder for the integration. This is the responder that will be used to send messages to the user. For more information, refer to the <a href=\"https://developer.zendesk.com/documentation/conversations/messaging-platform/programmable-conversations/switchboard/#default-integration-assignment\">Switchboard guide</a>. ")
@JsonPropertyOrder(value={"name", "integrationId", "integrationType", "deliverStandbyEvents", "nextSwitchboardIntegrationId", "messageHistoryCount", "inherited"})
public class DefaultResponderDefaultResponder {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_INTEGRATION_ID = "integrationId";
    private String integrationId;
    public static final String JSON_PROPERTY_INTEGRATION_TYPE = "integrationType";
    private String integrationType;
    public static final String JSON_PROPERTY_DELIVER_STANDBY_EVENTS = "deliverStandbyEvents";
    private Boolean deliverStandbyEvents;
    public static final String JSON_PROPERTY_NEXT_SWITCHBOARD_INTEGRATION_ID = "nextSwitchboardIntegrationId";
    private JsonNullable<String> nextSwitchboardIntegrationId = JsonNullable.undefined();
    public static final String JSON_PROPERTY_MESSAGE_HISTORY_COUNT = "messageHistoryCount";
    private BigDecimal messageHistoryCount;
    public static final String JSON_PROPERTY_INHERITED = "inherited";
    private Boolean inherited;

    public DefaultResponderDefaultResponder name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the switchboard integration.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DefaultResponderDefaultResponder integrationId(String integrationId) {
        this.integrationId = integrationId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="5e4af71a81966cfff3ef6550", value="The unique ID of the integration.")
    @JsonProperty(value="integrationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIntegrationId() {
        return this.integrationId;
    }

    public void setIntegrationId(String integrationId) {
        this.integrationId = integrationId;
    }

    public DefaultResponderDefaultResponder integrationType(String integrationType) {
        this.integrationType = integrationType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of the integration.")
    @JsonProperty(value="integrationType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIntegrationType() {
        return this.integrationType;
    }

    public void setIntegrationType(String integrationType) {
        this.integrationType = integrationType;
    }

    public DefaultResponderDefaultResponder deliverStandbyEvents(Boolean deliverStandbyEvents) {
        this.deliverStandbyEvents = deliverStandbyEvents;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether the switchboard should deliver standby events.")
    @JsonProperty(value="deliverStandbyEvents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getDeliverStandbyEvents() {
        return this.deliverStandbyEvents;
    }

    public void setDeliverStandbyEvents(Boolean deliverStandbyEvents) {
        this.deliverStandbyEvents = deliverStandbyEvents;
    }

    public DefaultResponderDefaultResponder nextSwitchboardIntegrationId(String nextSwitchboardIntegrationId) {
        this.nextSwitchboardIntegrationId = JsonNullable.of((Object)nextSwitchboardIntegrationId);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique ID of the next switchboard integration.")
    @JsonIgnore
    public String getNextSwitchboardIntegrationId() {
        return (String)this.nextSwitchboardIntegrationId.orElse(null);
    }

    @JsonProperty(value="nextSwitchboardIntegrationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getNextSwitchboardIntegrationId_JsonNullable() {
        return this.nextSwitchboardIntegrationId;
    }

    @JsonProperty(value="nextSwitchboardIntegrationId")
    public void setNextSwitchboardIntegrationId_JsonNullable(JsonNullable<String> nextSwitchboardIntegrationId) {
        this.nextSwitchboardIntegrationId = nextSwitchboardIntegrationId;
    }

    public void setNextSwitchboardIntegrationId(String nextSwitchboardIntegrationId) {
        this.nextSwitchboardIntegrationId = JsonNullable.of((Object)nextSwitchboardIntegrationId);
    }

    public DefaultResponderDefaultResponder messageHistoryCount(BigDecimal messageHistoryCount) {
        this.messageHistoryCount = messageHistoryCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of messages to keep in the message history.")
    @JsonProperty(value="messageHistoryCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getMessageHistoryCount() {
        return this.messageHistoryCount;
    }

    public void setMessageHistoryCount(BigDecimal messageHistoryCount) {
        this.messageHistoryCount = messageHistoryCount;
    }

    public DefaultResponderDefaultResponder inherited(Boolean inherited) {
        this.inherited = inherited;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether the default responder is inherited from the switchboard's global config or not. Returns `false` if a per-channel responder override has been set for this integration, and `true` otherwise.")
    @JsonProperty(value="inherited")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getInherited() {
        return this.inherited;
    }

    public void setInherited(Boolean inherited) {
        this.inherited = inherited;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultResponderDefaultResponder defaultResponderDefaultResponder = (DefaultResponderDefaultResponder)o;
        return Objects.equals(this.name, defaultResponderDefaultResponder.name) && Objects.equals(this.integrationId, defaultResponderDefaultResponder.integrationId) && Objects.equals(this.integrationType, defaultResponderDefaultResponder.integrationType) && Objects.equals(this.deliverStandbyEvents, defaultResponderDefaultResponder.deliverStandbyEvents) && Objects.equals(this.nextSwitchboardIntegrationId, defaultResponderDefaultResponder.nextSwitchboardIntegrationId) && Objects.equals(this.messageHistoryCount, defaultResponderDefaultResponder.messageHistoryCount) && Objects.equals(this.inherited, defaultResponderDefaultResponder.inherited);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.integrationId, this.integrationType, this.deliverStandbyEvents, this.nextSwitchboardIntegrationId, this.messageHistoryCount, this.inherited);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DefaultResponderDefaultResponder {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    integrationId: ").append(this.toIndentedString(this.integrationId)).append("\n");
        sb.append("    integrationType: ").append(this.toIndentedString(this.integrationType)).append("\n");
        sb.append("    deliverStandbyEvents: ").append(this.toIndentedString(this.deliverStandbyEvents)).append("\n");
        sb.append("    nextSwitchboardIntegrationId: ").append(this.toIndentedString(this.nextSwitchboardIntegrationId)).append("\n");
        sb.append("    messageHistoryCount: ").append(this.toIndentedString(this.messageHistoryCount)).append("\n");
        sb.append("    inherited: ").append(this.toIndentedString(this.inherited)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

