/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;

@ApiModel(description="Messenger channel options.")
@JsonPropertyOrder(value={"messenger_extensions", "webview_share_button"})
public class ExtraChannelOptionsMessenger {
    public static final String JSON_PROPERTY_MESSENGER_EXTENSIONS = "messenger_extensions";
    private Boolean messengerExtensions = false;
    public static final String JSON_PROPERTY_WEBVIEW_SHARE_BUTTON = "webview_share_button";
    private WebviewShareButtonEnum webviewShareButton;

    public ExtraChannelOptionsMessenger messengerExtensions(Boolean messengerExtensions) {
        this.messengerExtensions = messengerExtensions;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="For webview type actions, a boolean value indicating whether the URL should be loaded with Messenger Extensions enabled. [More info](https://developers.facebook.com/docs/messenger-platform/send-api-reference/url-button).")
    @JsonProperty(value="messenger_extensions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getMessengerExtensions() {
        return this.messengerExtensions;
    }

    public void setMessengerExtensions(Boolean messengerExtensions) {
        this.messengerExtensions = messengerExtensions;
    }

    public ExtraChannelOptionsMessenger webviewShareButton(WebviewShareButtonEnum webviewShareButton) {
        this.webviewShareButton = webviewShareButton;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="For webview type actions, a string value indicating if the share button should be hidden. [More Info](https://developers.facebook.com/docs/messenger-platform/reference/buttons/url).")
    @JsonProperty(value="webview_share_button")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WebviewShareButtonEnum getWebviewShareButton() {
        return this.webviewShareButton;
    }

    public void setWebviewShareButton(WebviewShareButtonEnum webviewShareButton) {
        this.webviewShareButton = webviewShareButton;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtraChannelOptionsMessenger extraChannelOptionsMessenger = (ExtraChannelOptionsMessenger)o;
        return Objects.equals(this.messengerExtensions, extraChannelOptionsMessenger.messengerExtensions) && Objects.equals((Object)this.webviewShareButton, (Object)extraChannelOptionsMessenger.webviewShareButton);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.messengerExtensions, this.webviewShareButton});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExtraChannelOptionsMessenger {\n");
        sb.append("    messengerExtensions: ").append(this.toIndentedString(this.messengerExtensions)).append("\n");
        sb.append("    webviewShareButton: ").append(this.toIndentedString((Object)this.webviewShareButton)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum WebviewShareButtonEnum {
        HIDE("hide");

        private String value;

        private WebviewShareButtonEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static WebviewShareButtonEnum fromValue(String value) {
            for (WebviewShareButtonEnum b : WebviewShareButtonEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

