/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.Content;
import com.zendesk.sunshine_conversations_client.model.FormMessageField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A form type message without text or actions. Only supported in the Web SDK.")
@JsonPropertyOrder(value={"type", "submitted", "blockChatInput", "fields"})
public class FormMessage
implements Content {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type = "form";
    public static final String JSON_PROPERTY_SUBMITTED = "submitted";
    private Boolean submitted;
    public static final String JSON_PROPERTY_BLOCK_CHAT_INPUT = "blockChatInput";
    private Boolean blockChatInput;
    public static final String JSON_PROPERTY_FIELDS = "fields";
    private List<FormMessageField> fields = new ArrayList<FormMessageField>();

    public FormMessage type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @ApiModelProperty(required=true, value="The type of message.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Nullable
    @ApiModelProperty(value="Flag which states whether the form is submitted.")
    @JsonProperty(value="submitted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSubmitted() {
        return this.submitted;
    }

    public FormMessage blockChatInput(Boolean blockChatInput) {
        this.blockChatInput = blockChatInput;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When set to true, the chat input will be disabled on supported client implementations when the message is the most recent one in the history. Can be used for guided flows or to temporarily disable the user's ability to send messages in the conversation..")
    @JsonProperty(value="blockChatInput")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getBlockChatInput() {
        return this.blockChatInput;
    }

    public void setBlockChatInput(Boolean blockChatInput) {
        this.blockChatInput = blockChatInput;
    }

    public FormMessage fields(List<FormMessageField> fields) {
        this.fields = fields;
        return this;
    }

    public FormMessage addFieldsItem(FormMessageField fieldsItem) {
        this.fields.add(fieldsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An array of objects representing fields associated with the message. Only present in form and formResponse messages.")
    @JsonProperty(value="fields")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<FormMessageField> getFields() {
        return this.fields;
    }

    public void setFields(List<FormMessageField> fields) {
        this.fields = fields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormMessage formMessage = (FormMessage)o;
        return Objects.equals(this.type, formMessage.type) && Objects.equals(this.submitted, formMessage.submitted) && Objects.equals(this.blockChatInput, formMessage.blockChatInput) && Objects.equals(this.fields, formMessage.fields);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.submitted, this.blockChatInput, this.fields);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FormMessage {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    submitted: ").append(this.toIndentedString(this.submitted)).append("\n");
        sb.append("    blockChatInput: ").append(this.toIndentedString(this.blockChatInput)).append("\n");
        sb.append("    fields: ").append(this.toIndentedString(this.fields)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

