/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.IntegrationUpdate;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"displayName", "defaultResponderId", "pageAccessToken"})
public class InstagramUpdate
implements IntegrationUpdate {
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private JsonNullable<String> displayName = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DEFAULT_RESPONDER_ID = "defaultResponderId";
    private JsonNullable<String> defaultResponderId = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PAGE_ACCESS_TOKEN = "pageAccessToken";
    private String pageAccessToken;

    public InstagramUpdate displayName(String displayName) {
        this.displayName = JsonNullable.of((Object)displayName);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="My awesome integration", value="A human-friendly name used to identify the integration. `displayName` can be unset by changing it to `null`.")
    @JsonIgnore
    public String getDisplayName() {
        return (String)this.displayName.orElse(null);
    }

    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDisplayName_JsonNullable() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName_JsonNullable(JsonNullable<String> displayName) {
        this.displayName = displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = JsonNullable.of((Object)displayName);
    }

    public InstagramUpdate defaultResponderId(String defaultResponderId) {
        this.defaultResponderId = JsonNullable.of((Object)defaultResponderId);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The default responder ID for the integration. This is the ID of the responder that will be used to send messages to the user. For more information, refer to the <a href=\"https://developer.zendesk.com/documentation/conversations/messaging-platform/programmable-conversations/switchboard/#default-integration-assignment\">Switchboard guide</a>. ")
    @JsonIgnore
    public String getDefaultResponderId() {
        return (String)this.defaultResponderId.orElse(null);
    }

    @JsonProperty(value="defaultResponderId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDefaultResponderId_JsonNullable() {
        return this.defaultResponderId;
    }

    @JsonProperty(value="defaultResponderId")
    public void setDefaultResponderId_JsonNullable(JsonNullable<String> defaultResponderId) {
        this.defaultResponderId = defaultResponderId;
    }

    public void setDefaultResponderId(String defaultResponderId) {
        this.defaultResponderId = JsonNullable.of((Object)defaultResponderId);
    }

    public InstagramUpdate pageAccessToken(String pageAccessToken) {
        this.pageAccessToken = pageAccessToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="your_access_token", value="A Facebook Page Access Token.")
    @JsonProperty(value="pageAccessToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPageAccessToken() {
        return this.pageAccessToken;
    }

    public void setPageAccessToken(String pageAccessToken) {
        this.pageAccessToken = pageAccessToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstagramUpdate instagramUpdate = (InstagramUpdate)o;
        return Objects.equals(this.displayName, instagramUpdate.displayName) && Objects.equals(this.defaultResponderId, instagramUpdate.defaultResponderId) && Objects.equals(this.pageAccessToken, instagramUpdate.pageAccessToken);
    }

    public int hashCode() {
        return Objects.hash(this.displayName, this.defaultResponderId, this.pageAccessToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InstagramUpdate {\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    defaultResponderId: ").append(this.toIndentedString(this.defaultResponderId)).append("\n");
        sb.append("    pageAccessToken: ").append(this.toIndentedString(this.pageAccessToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

