/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"type", "apiKey", "domain", "incomingAddress", "hideUnsubscribeLink", "fromAddress"})
public class MailgunAllOf {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type = "mailgun";
    public static final String JSON_PROPERTY_API_KEY = "apiKey";
    private String apiKey;
    public static final String JSON_PROPERTY_DOMAIN = "domain";
    private String domain;
    public static final String JSON_PROPERTY_INCOMING_ADDRESS = "incomingAddress";
    private String incomingAddress;
    public static final String JSON_PROPERTY_HIDE_UNSUBSCRIBE_LINK = "hideUnsubscribeLink";
    private Boolean hideUnsubscribeLink;
    public static final String JSON_PROPERTY_FROM_ADDRESS = "fromAddress";
    private JsonNullable<String> fromAddress = JsonNullable.undefined();

    public MailgunAllOf type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="To configure a Mailgun integration, visit the API Keys tab in the settings page of the Mailgun dashboard and copy your active API key. Call the Create Integration endpoint with your API Key, a domain you have configured in Mailgun, and the incoming address you would like to use. Must have the same domain as the one specified in the domain parameter. ")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public MailgunAllOf apiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="key-f265hj32f0sd897lqd2j5keb96784043", required=true, value="The public API key of your Mailgun account.")
    @JsonProperty(value="apiKey")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public MailgunAllOf domain(String domain) {
        this.domain = domain;
        return this;
    }

    @ApiModelProperty(example="sandbox123.mailgun.org", required=true, value="The domain used to relay email. This domain must be configured and verified in your Mailgun account.")
    @JsonProperty(value="domain")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public MailgunAllOf incomingAddress(String incomingAddress) {
        this.incomingAddress = incomingAddress;
        return this;
    }

    @ApiModelProperty(example="mytestemail@sandbox123.mailgun.org", required=true, value="Sunshine Conversations will receive all emails sent to this address. It will also be used as the Reply-To address.")
    @JsonProperty(value="incomingAddress")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIncomingAddress() {
        return this.incomingAddress;
    }

    public void setIncomingAddress(String incomingAddress) {
        this.incomingAddress = incomingAddress;
    }

    public MailgunAllOf hideUnsubscribeLink(Boolean hideUnsubscribeLink) {
        this.hideUnsubscribeLink = hideUnsubscribeLink;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A boolean value indicating whether the unsubscribe link should be omitted from outgoing emails. When enabled, it is expected that the business is providing the user a way to unsubscribe by some other means. By default, the unsubscribe link will be included in all outgoing emails.")
    @JsonProperty(value="hideUnsubscribeLink")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHideUnsubscribeLink() {
        return this.hideUnsubscribeLink;
    }

    public void setHideUnsubscribeLink(Boolean hideUnsubscribeLink) {
        this.hideUnsubscribeLink = hideUnsubscribeLink;
    }

    public MailgunAllOf fromAddress(String fromAddress) {
        this.fromAddress = JsonNullable.of((Object)fromAddress);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="test@sandbox123.mailgun.org", value="Email address to use as the From and Reply-To address if it must be different from incomingAddress. Only use this option if the address that you supply is configured to forward emails to the incomingAddress, otherwise user replies will be lost. You must also make sure that the domain is properly configured as a mail provider so as to not be flagged as spam by the user\u2019s email client. May be unset with null.")
    @JsonIgnore
    public String getFromAddress() {
        return (String)this.fromAddress.orElse(null);
    }

    @JsonProperty(value="fromAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getFromAddress_JsonNullable() {
        return this.fromAddress;
    }

    @JsonProperty(value="fromAddress")
    public void setFromAddress_JsonNullable(JsonNullable<String> fromAddress) {
        this.fromAddress = fromAddress;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = JsonNullable.of((Object)fromAddress);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MailgunAllOf mailgunAllOf = (MailgunAllOf)o;
        return Objects.equals(this.type, mailgunAllOf.type) && Objects.equals(this.apiKey, mailgunAllOf.apiKey) && Objects.equals(this.domain, mailgunAllOf.domain) && Objects.equals(this.incomingAddress, mailgunAllOf.incomingAddress) && Objects.equals(this.hideUnsubscribeLink, mailgunAllOf.hideUnsubscribeLink) && Objects.equals(this.fromAddress, mailgunAllOf.fromAddress);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.apiKey, this.domain, this.incomingAddress, this.hideUnsubscribeLink, this.fromAddress);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MailgunAllOf {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    apiKey: ").append(this.toIndentedString(this.apiKey)).append("\n");
        sb.append("    domain: ").append(this.toIndentedString(this.domain)).append("\n");
        sb.append("    incomingAddress: ").append(this.toIndentedString(this.incomingAddress)).append("\n");
        sb.append("    hideUnsubscribeLink: ").append(this.toIndentedString(this.hideUnsubscribeLink)).append("\n");
        sb.append("    fromAddress: ").append(this.toIndentedString(this.fromAddress)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

