/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.zendesk.sunshine_conversations_client.model.Android;
import com.zendesk.sunshine_conversations_client.model.Apple;
import com.zendesk.sunshine_conversations_client.model.Custom;
import com.zendesk.sunshine_conversations_client.model.DefaultResponderDefaultResponder;
import com.zendesk.sunshine_conversations_client.model.Instagram;
import com.zendesk.sunshine_conversations_client.model.Integration;
import com.zendesk.sunshine_conversations_client.model.Ios;
import com.zendesk.sunshine_conversations_client.model.Line;
import com.zendesk.sunshine_conversations_client.model.Mailgun;
import com.zendesk.sunshine_conversations_client.model.Messenger;
import com.zendesk.sunshine_conversations_client.model.Telegram;
import com.zendesk.sunshine_conversations_client.model.Twilio;
import com.zendesk.sunshine_conversations_client.model.Twitter;
import com.zendesk.sunshine_conversations_client.model.Unity;
import com.zendesk.sunshine_conversations_client.model.Viber;
import com.zendesk.sunshine_conversations_client.model.Web;
import com.zendesk.sunshine_conversations_client.model.Whatsapp;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"type", "accessKey", "signingKey", "originator", "webhookSecret", "defaultResponderId", "defaultResponder"})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=Android.class, name="android"), @JsonSubTypes.Type(value=Apple.class, name="apple"), @JsonSubTypes.Type(value=Custom.class, name="custom"), @JsonSubTypes.Type(value=Instagram.class, name="instagram"), @JsonSubTypes.Type(value=Ios.class, name="ios"), @JsonSubTypes.Type(value=Line.class, name="line"), @JsonSubTypes.Type(value=Mailgun.class, name="mailgun"), @JsonSubTypes.Type(value=Messagebird.class, name="messagebird"), @JsonSubTypes.Type(value=Messenger.class, name="messenger"), @JsonSubTypes.Type(value=Telegram.class, name="telegram"), @JsonSubTypes.Type(value=Twilio.class, name="twilio"), @JsonSubTypes.Type(value=Twitter.class, name="twitter"), @JsonSubTypes.Type(value=Unity.class, name="unity"), @JsonSubTypes.Type(value=Viber.class, name="viber"), @JsonSubTypes.Type(value=Web.class, name="web"), @JsonSubTypes.Type(value=Whatsapp.class, name="whatsapp")})
public class Messagebird
extends Integration {
    public static final String JSON_PROPERTY_TYPE = "type";
    protected String type = "messagebird";
    public static final String JSON_PROPERTY_ACCESS_KEY = "accessKey";
    private String accessKey;
    public static final String JSON_PROPERTY_SIGNING_KEY = "signingKey";
    private String signingKey;
    public static final String JSON_PROPERTY_ORIGINATOR = "originator";
    private String originator;
    public static final String JSON_PROPERTY_WEBHOOK_SECRET = "webhookSecret";
    private String webhookSecret;
    public static final String JSON_PROPERTY_DEFAULT_RESPONDER_ID = "defaultResponderId";
    private JsonNullable<String> defaultResponderId = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DEFAULT_RESPONDER = "defaultResponder";
    private JsonNullable<DefaultResponderDefaultResponder> defaultResponder = JsonNullable.undefined();

    @Override
    public Messagebird type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @Nullable
    @ApiModelProperty(value="To configure a MessageBird integration, acquire the accessKey, the signingKey and the MessageBird number you would like to use, then call the Create Integration endpoint. The response will include the integration\u2019s `_id` and `webhookSecret`, which must be used to configure the webhook in MessageBird. In the Flow Builder for the MessageBird number you\u2019ve used to integrate, add a new step with the following settings: - Create a new Call HTTP endpoint with SMS flow. - Select your desired SMS number for Incoming SMS. - Click on Forward to URL and set its method to POST. - Then, using the integration _id and webhookSecret returned from the create integration call, enter the following into the URL field:  `https://app.smooch.io/api/messagebird/webhooks/{appId}/{integrationId}/{webhookSecret}` - Select application/json for the Set Content-Type header field. - Save and publish your changes. ")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public Messagebird accessKey(String accessKey) {
        this.accessKey = accessKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="9V2iJmd93kFJ390L9495JCl11", required=true, value="The public API key of your MessageBird account.")
    @JsonProperty(value="accessKey")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public Messagebird signingKey(String signingKey) {
        this.signingKey = signingKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Uu6N09Lkdji3820DJIO89I39sl9dJ", required=true, value="The signing key of your MessageBird account. Used to validate the webhooks' origin.")
    @JsonProperty(value="signingKey")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSigningKey() {
        return this.signingKey;
    }

    public void setSigningKey(String signingKey) {
        this.signingKey = signingKey;
    }

    public Messagebird originator(String originator) {
        this.originator = originator;
        return this;
    }

    @ApiModelProperty(example="12262121021", required=true, value="Sunshine Conversations will receive all messages sent to this phone number.")
    @JsonProperty(value="originator")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getOriginator() {
        return this.originator;
    }

    public void setOriginator(String originator) {
        this.originator = originator;
    }

    @Nullable
    @ApiModelProperty(example="72ade38394d1da51566cede33bd1e67e", value="The secret that is used to configure webhooks in MessageBird.")
    @JsonProperty(value="webhookSecret")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWebhookSecret() {
        return this.webhookSecret;
    }

    public Messagebird defaultResponderId(String defaultResponderId) {
        this.defaultResponderId = JsonNullable.of((Object)defaultResponderId);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The default responder ID for the integration. This is the ID of the responder that will be used to send messages to the user. For more information, refer to the <a href=\"https://developer.zendesk.com/documentation/conversations/messaging-platform/programmable-conversations/switchboard/#default-integration-assignment\">Switchboard guide</a>. ")
    @JsonIgnore
    public String getDefaultResponderId() {
        return (String)this.defaultResponderId.orElse(null);
    }

    @JsonProperty(value="defaultResponderId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDefaultResponderId_JsonNullable() {
        return this.defaultResponderId;
    }

    @JsonProperty(value="defaultResponderId")
    public void setDefaultResponderId_JsonNullable(JsonNullable<String> defaultResponderId) {
        this.defaultResponderId = defaultResponderId;
    }

    public void setDefaultResponderId(String defaultResponderId) {
        this.defaultResponderId = JsonNullable.of((Object)defaultResponderId);
    }

    public Messagebird defaultResponder(DefaultResponderDefaultResponder defaultResponder) {
        this.defaultResponder = JsonNullable.of((Object)defaultResponder);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public DefaultResponderDefaultResponder getDefaultResponder() {
        return (DefaultResponderDefaultResponder)this.defaultResponder.orElse(null);
    }

    @JsonProperty(value="defaultResponder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<DefaultResponderDefaultResponder> getDefaultResponder_JsonNullable() {
        return this.defaultResponder;
    }

    @JsonProperty(value="defaultResponder")
    public void setDefaultResponder_JsonNullable(JsonNullable<DefaultResponderDefaultResponder> defaultResponder) {
        this.defaultResponder = defaultResponder;
    }

    public void setDefaultResponder(DefaultResponderDefaultResponder defaultResponder) {
        this.defaultResponder = JsonNullable.of((Object)defaultResponder);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Messagebird messagebird = (Messagebird)o;
        return Objects.equals(this.type, messagebird.type) && Objects.equals(this.accessKey, messagebird.accessKey) && Objects.equals(this.signingKey, messagebird.signingKey) && Objects.equals(this.originator, messagebird.originator) && Objects.equals(this.webhookSecret, messagebird.webhookSecret) && Objects.equals(this.defaultResponderId, messagebird.defaultResponderId) && Objects.equals(this.defaultResponder, messagebird.defaultResponder) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type, this.accessKey, this.signingKey, this.originator, this.webhookSecret, this.defaultResponderId, this.defaultResponder, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Messagebird {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    accessKey: ").append(this.toIndentedString(this.accessKey)).append("\n");
        sb.append("    signingKey: ").append(this.toIndentedString(this.signingKey)).append("\n");
        sb.append("    originator: ").append(this.toIndentedString(this.originator)).append("\n");
        sb.append("    webhookSecret: ").append(this.toIndentedString(this.webhookSecret)).append("\n");
        sb.append("    defaultResponderId: ").append(this.toIndentedString(this.defaultResponderId)).append("\n");
        sb.append("    defaultResponder: ").append(this.toIndentedString(this.defaultResponder)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

