/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.ReferralDetails;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Data representing a referral object when a user is referred to a conversation. See the <a href=\"https://developer.zendesk.com/documentation/conversations/messaging-platform/programmable-conversations/conversation-referrals/\">conversation referrals</a> guide for more details. ")
@JsonPropertyOrder(value={"code", "details"})
public class Referral {
    public static final String JSON_PROPERTY_CODE = "code";
    private String code;
    public static final String JSON_PROPERTY_DETAILS = "details";
    private JsonNullable<ReferralDetails> details = JsonNullable.undefined();

    public Referral code(String code) {
        this.code = code;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The referral\u2019s identifier.")
    @JsonProperty(value="code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Referral details(ReferralDetails details) {
        this.details = JsonNullable.of((Object)details);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public ReferralDetails getDetails() {
        return (ReferralDetails)this.details.orElse(null);
    }

    @JsonProperty(value="details")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<ReferralDetails> getDetails_JsonNullable() {
        return this.details;
    }

    @JsonProperty(value="details")
    public void setDetails_JsonNullable(JsonNullable<ReferralDetails> details) {
        this.details = details;
    }

    public void setDetails(ReferralDetails details) {
        this.details = JsonNullable.of((Object)details);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Referral referral = (Referral)o;
        return Objects.equals(this.code, referral.code) && Objects.equals(this.details, referral.details);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.details);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Referral {\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    details: ").append(this.toIndentedString(this.details)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

