/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.Content;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;

@JsonPropertyOrder(value={"type", "blockChatInput", "template"})
public class TemplateMessage
implements Content {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type = "template";
    public static final String JSON_PROPERTY_BLOCK_CHAT_INPUT = "blockChatInput";
    private Boolean blockChatInput;
    public static final String JSON_PROPERTY_TEMPLATE = "template";
    private Object template;

    public TemplateMessage type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @ApiModelProperty(required=true, value="The type of message.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public TemplateMessage blockChatInput(Boolean blockChatInput) {
        this.blockChatInput = blockChatInput;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When set to true, the chat input will be disabled on supported client implementations when the message is the most recent one in the history. Can be used for guided flows or to temporarily disable the user's ability to send messages in the conversation.")
    @JsonProperty(value="blockChatInput")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getBlockChatInput() {
        return this.blockChatInput;
    }

    public void setBlockChatInput(Boolean blockChatInput) {
        this.blockChatInput = blockChatInput;
    }

    public TemplateMessage template(Object template) {
        this.template = template;
        return this;
    }

    @ApiModelProperty(required=true, value="The whatsapp template message to send. For more information, consult the [guide](https://docs.smooch.io/guide/whatsapp#sending-message-templates). `schema` must be set to `whatsapp`.")
    @JsonProperty(value="template")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Object getTemplate() {
        return this.template;
    }

    public void setTemplate(Object template) {
        this.template = template;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateMessage templateMessage = (TemplateMessage)o;
        return Objects.equals(this.type, templateMessage.type) && Objects.equals(this.blockChatInput, templateMessage.blockChatInput) && Objects.equals(this.template, templateMessage.template);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.blockChatInput, this.template);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TemplateMessage {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    blockChatInput: ").append(this.toIndentedString(this.blockChatInput)).append("\n");
        sb.append("    template: ").append(this.toIndentedString(this.template)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

