/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.Action;
import com.zendesk.sunshine_conversations_client.model.Content;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"type", "text", "htmlText", "blockChatInput", "markdownText", "actions", "payload"})
public class TextMessage
implements Content {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type = "text";
    public static final String JSON_PROPERTY_TEXT = "text";
    private String text;
    public static final String JSON_PROPERTY_HTML_TEXT = "htmlText";
    private String htmlText;
    public static final String JSON_PROPERTY_BLOCK_CHAT_INPUT = "blockChatInput";
    private Boolean blockChatInput;
    public static final String JSON_PROPERTY_MARKDOWN_TEXT = "markdownText";
    private String markdownText;
    public static final String JSON_PROPERTY_ACTIONS = "actions";
    private List<Action> actions = null;
    public static final String JSON_PROPERTY_PAYLOAD = "payload";
    private String payload;

    public TextMessage type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @ApiModelProperty(required=true, value="The type of message.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public TextMessage text(String text) {
        this.text = text;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Hello!", value="The text content of the message. Required unless `actions`, `htmlText` or `markdownText` is provided.")
    @JsonProperty(value="text")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public TextMessage htmlText(String htmlText) {
        this.htmlText = htmlText;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="<h1>Hello!</h1>", value="HTML text content of the message. Can be provided in place of `text`. Cannot be used with `markdownText`. If no `text` is provided, will be converted to `text` upon reception to be displayed on channels that do not support rich text. See [rich text](https://developer.zendesk.com/documentation/conversations/messaging-platform/programmable-conversations/structured-messages/#rich-text) documentation for more information.")
    @JsonProperty(value="htmlText")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHtmlText() {
        return this.htmlText;
    }

    public void setHtmlText(String htmlText) {
        this.htmlText = htmlText;
    }

    public TextMessage blockChatInput(Boolean blockChatInput) {
        this.blockChatInput = blockChatInput;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When set to true, the chat input will be disabled on supported client implementations when the message is the most recent one in the history. Can be used for guided flows or to temporarily disable the user's ability to send messages in the conversation.")
    @JsonProperty(value="blockChatInput")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getBlockChatInput() {
        return this.blockChatInput;
    }

    public void setBlockChatInput(Boolean blockChatInput) {
        this.blockChatInput = blockChatInput;
    }

    public TextMessage markdownText(String markdownText) {
        this.markdownText = markdownText;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="# Hello!", value="Markdown text content of the message. Can be provided in place of `text`. Cannot be used with `htmlText`. Will be converted to `htmlText` upon reception. If converted `htmlText` exceeds 4096 characters, the message will be rejected. If no `text` is provided, will be converted to `text` upon reception to be displayed on channels that do not support rich text. See [rich text](https://developer.zendesk.com/documentation/conversations/messaging-platform/programmable-conversations/structured-messages/#rich-text) documentation for more information.")
    @JsonProperty(value="markdownText")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMarkdownText() {
        return this.markdownText;
    }

    public void setMarkdownText(String markdownText) {
        this.markdownText = markdownText;
    }

    public TextMessage actions(List<Action> actions) {
        this.actions = actions;
        return this;
    }

    public TextMessage addActionsItem(Action actionsItem) {
        if (this.actions == null) {
            this.actions = new ArrayList<Action>();
        }
        this.actions.add(actionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of message actions.")
    @JsonProperty(value="actions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Action> getActions() {
        return this.actions;
    }

    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    public TextMessage payload(String payload) {
        this.payload = payload;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The payload of a [reply button](https://developer.zendesk.com/documentation/conversations/messaging-platform/programmable-conversations/structured-messages/#reply-buttons) response message.")
    @JsonProperty(value="payload")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextMessage textMessage = (TextMessage)o;
        return Objects.equals(this.type, textMessage.type) && Objects.equals(this.text, textMessage.text) && Objects.equals(this.htmlText, textMessage.htmlText) && Objects.equals(this.blockChatInput, textMessage.blockChatInput) && Objects.equals(this.markdownText, textMessage.markdownText) && Objects.equals(this.actions, textMessage.actions) && Objects.equals(this.payload, textMessage.payload);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.text, this.htmlText, this.blockChatInput, this.markdownText, this.actions, this.payload);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TextMessage {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    htmlText: ").append(this.toIndentedString(this.htmlText)).append("\n");
        sb.append("    blockChatInput: ").append(this.toIndentedString(this.blockChatInput)).append("\n");
        sb.append("    markdownText: ").append(this.toIndentedString(this.markdownText)).append("\n");
        sb.append("    actions: ").append(this.toIndentedString(this.actions)).append("\n");
        sb.append("    payload: ").append(this.toIndentedString(this.payload)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

