/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.ActivityMessage;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"type", "data"})
public class TransferToEmail
implements ActivityMessage {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type = "ticket:transfer:email";
    public static final String JSON_PROPERTY_DATA = "data";
    private Map<String, Object> data = null;

    public TransferToEmail type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @ApiModelProperty(required=true, value="The type of system activity that generated the message. The value of this field determines the dynamic content that is rendered to the end-user / agent when viewing this message. Each `type` value will have a set of pre-defined, localized strings that describe the activity.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public TransferToEmail data(Map<String, Object> data) {
        this.data = data;
        return this;
    }

    public TransferToEmail putDataItem(String key, Object dataItem) {
        if (this.data == null) {
            this.data = new HashMap<String, Object>();
        }
        this.data.put(key, dataItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="No additional data is supplied with the \"ticket:transfer:email\" activity type at this time.")
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getData() {
        return this.data;
    }

    public void setData(Map<String, Object> data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferToEmail transferToEmail = (TransferToEmail)o;
        return Objects.equals(this.type, transferToEmail.type) && Objects.equals(this.data, transferToEmail.data);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.data);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferToEmail {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

