/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.IntegrationUpdate;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"displayName", "defaultResponderId", "canUserSeeConversationList", "canUserCreateMoreConversations"})
public class UnityUpdate
implements IntegrationUpdate {
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private JsonNullable<String> displayName = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DEFAULT_RESPONDER_ID = "defaultResponderId";
    private JsonNullable<String> defaultResponderId = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CAN_USER_SEE_CONVERSATION_LIST = "canUserSeeConversationList";
    private Boolean canUserSeeConversationList;
    public static final String JSON_PROPERTY_CAN_USER_CREATE_MORE_CONVERSATIONS = "canUserCreateMoreConversations";
    private Boolean canUserCreateMoreConversations;

    public UnityUpdate displayName(String displayName) {
        this.displayName = JsonNullable.of((Object)displayName);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="My awesome integration", value="A human-friendly name used to identify the integration. `displayName` can be unset by changing it to `null`.")
    @JsonIgnore
    public String getDisplayName() {
        return (String)this.displayName.orElse(null);
    }

    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDisplayName_JsonNullable() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName_JsonNullable(JsonNullable<String> displayName) {
        this.displayName = displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = JsonNullable.of((Object)displayName);
    }

    public UnityUpdate defaultResponderId(String defaultResponderId) {
        this.defaultResponderId = JsonNullable.of((Object)defaultResponderId);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The default responder ID for the integration. This is the ID of the responder that will be used to send messages to the user. For more information, refer to the <a href=\"https://developer.zendesk.com/documentation/conversations/messaging-platform/programmable-conversations/switchboard/#default-integration-assignment\">Switchboard guide</a>. ")
    @JsonIgnore
    public String getDefaultResponderId() {
        return (String)this.defaultResponderId.orElse(null);
    }

    @JsonProperty(value="defaultResponderId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDefaultResponderId_JsonNullable() {
        return this.defaultResponderId;
    }

    @JsonProperty(value="defaultResponderId")
    public void setDefaultResponderId_JsonNullable(JsonNullable<String> defaultResponderId) {
        this.defaultResponderId = defaultResponderId;
    }

    public void setDefaultResponderId(String defaultResponderId) {
        this.defaultResponderId = JsonNullable.of((Object)defaultResponderId);
    }

    public UnityUpdate canUserSeeConversationList(Boolean canUserSeeConversationList) {
        this.canUserSeeConversationList = canUserSeeConversationList;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Allows users to view their list of conversations. By default, the list of conversations will be visible. *This setting only applies to apps where `settings.multiConvoEnabled` is set to `true`*. ")
    @JsonProperty(value="canUserSeeConversationList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCanUserSeeConversationList() {
        return this.canUserSeeConversationList;
    }

    public void setCanUserSeeConversationList(Boolean canUserSeeConversationList) {
        this.canUserSeeConversationList = canUserSeeConversationList;
    }

    public UnityUpdate canUserCreateMoreConversations(Boolean canUserCreateMoreConversations) {
        this.canUserCreateMoreConversations = canUserCreateMoreConversations;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Allows users to create more than one conversation on the Unity integration.")
    @JsonProperty(value="canUserCreateMoreConversations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCanUserCreateMoreConversations() {
        return this.canUserCreateMoreConversations;
    }

    public void setCanUserCreateMoreConversations(Boolean canUserCreateMoreConversations) {
        this.canUserCreateMoreConversations = canUserCreateMoreConversations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnityUpdate unityUpdate = (UnityUpdate)o;
        return Objects.equals(this.displayName, unityUpdate.displayName) && Objects.equals(this.defaultResponderId, unityUpdate.defaultResponderId) && Objects.equals(this.canUserSeeConversationList, unityUpdate.canUserSeeConversationList) && Objects.equals(this.canUserCreateMoreConversations, unityUpdate.canUserCreateMoreConversations);
    }

    public int hashCode() {
        return Objects.hash(this.displayName, this.defaultResponderId, this.canUserSeeConversationList, this.canUserCreateMoreConversations);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UnityUpdate {\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    defaultResponderId: ").append(this.toIndentedString(this.defaultResponderId)).append("\n");
        sb.append("    canUserSeeConversationList: ").append(this.toIndentedString(this.canUserSeeConversationList)).append("\n");
        sb.append("    canUserCreateMoreConversations: ").append(this.toIndentedString(this.canUserCreateMoreConversations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

