/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.Profile;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"externalId", "signedUpAt", "toBeRetained", "profile", "metadata"})
public class UserCreateBody {
    public static final String JSON_PROPERTY_EXTERNAL_ID = "externalId";
    private String externalId;
    public static final String JSON_PROPERTY_SIGNED_UP_AT = "signedUpAt";
    private String signedUpAt;
    public static final String JSON_PROPERTY_TO_BE_RETAINED = "toBeRetained";
    private Boolean toBeRetained;
    public static final String JSON_PROPERTY_PROFILE = "profile";
    private Profile profile;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private JsonNullable<Map<String, Object>> metadata = JsonNullable.undefined();

    public UserCreateBody externalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    @ApiModelProperty(example="your-own-id", required=true, value="A unique identifier for the user. The `externalId` can be used to link a user to the same conversation [across multiple devices](https://developer.zendesk.com/documentation/conversations/messaging-platform/users/authenticating-users/). ")
    @JsonProperty(value="externalId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public UserCreateBody signedUpAt(String signedUpAt) {
        this.signedUpAt = signedUpAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2020-05-21T15:53:30.197Z", value="The date at which the user signed up. Must be ISO 8601 time format `YYYY-MM-DDThh:mm:ss.sssZ`.")
    @JsonProperty(value="signedUpAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSignedUpAt() {
        return this.signedUpAt;
    }

    public void setSignedUpAt(String signedUpAt) {
        this.signedUpAt = signedUpAt;
    }

    public UserCreateBody toBeRetained(Boolean toBeRetained) {
        this.toBeRetained = toBeRetained;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Flag indicating whether a user should be retained after they have passed their inactive expiry. See [creating deletion schedules for bot-only conversations](https://support.zendesk.com/hc/en-us/articles/8499219792154) for more information.")
    @JsonProperty(value="toBeRetained")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getToBeRetained() {
        return this.toBeRetained;
    }

    public void setToBeRetained(Boolean toBeRetained) {
        this.toBeRetained = toBeRetained;
    }

    public UserCreateBody profile(Profile profile) {
        this.profile = profile;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="profile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Profile getProfile() {
        return this.profile;
    }

    public void setProfile(Profile profile) {
        this.profile = profile;
    }

    public UserCreateBody metadata(Map<String, Object> metadata) {
        this.metadata = JsonNullable.of(metadata);
        return this;
    }

    public UserCreateBody putMetadataItem(String key, Object metadataItem) {
        if (this.metadata == null || !this.metadata.isPresent()) {
            this.metadata = JsonNullable.of(new HashMap());
        }
        try {
            ((Map)this.metadata.get()).put(key, metadataItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"lang\":\"en-ca\"}", value="Flat object containing custom properties. Strings, numbers and booleans  are the only supported format that can be passed to metadata. The metadata is limited to 4KB in size. ")
    @JsonIgnore
    public Map<String, Object> getMetadata() {
        return (Map)this.metadata.orElse(null);
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Map<String, Object>> getMetadata_JsonNullable() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata_JsonNullable(JsonNullable<Map<String, Object>> metadata) {
        this.metadata = metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = JsonNullable.of(metadata);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserCreateBody userCreateBody = (UserCreateBody)o;
        return Objects.equals(this.externalId, userCreateBody.externalId) && Objects.equals(this.signedUpAt, userCreateBody.signedUpAt) && Objects.equals(this.toBeRetained, userCreateBody.toBeRetained) && Objects.equals(this.profile, userCreateBody.profile) && Objects.equals(this.metadata, userCreateBody.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.externalId, this.signedUpAt, this.toBeRetained, this.profile, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserCreateBody {\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    signedUpAt: ").append(this.toIndentedString(this.signedUpAt)).append("\n");
        sb.append("    toBeRetained: ").append(this.toIndentedString(this.toBeRetained)).append("\n");
        sb.append("    profile: ").append(this.toIndentedString(this.profile)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

