/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"hsmFallbackLanguage", "accountId", "accountManagementAccessToken"})
public class WhatsAppUpdateAllOf {
    public static final String JSON_PROPERTY_HSM_FALLBACK_LANGUAGE = "hsmFallbackLanguage";
    private JsonNullable<String> hsmFallbackLanguage = JsonNullable.of((Object)"en_US");
    public static final String JSON_PROPERTY_ACCOUNT_ID = "accountId";
    private JsonNullable<String> accountId = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ACCOUNT_MANAGEMENT_ACCESS_TOKEN = "accountManagementAccessToken";
    private JsonNullable<String> accountManagementAccessToken = JsonNullable.undefined();

    public WhatsAppUpdateAllOf hsmFallbackLanguage(String hsmFallbackLanguage) {
        this.hsmFallbackLanguage = JsonNullable.of((Object)hsmFallbackLanguage);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specify a fallback language to use when sending WhatsApp message template using the short hand syntax. Defaults to en_US. See WhatsApp documentation for more info.")
    @JsonIgnore
    public String getHsmFallbackLanguage() {
        return (String)this.hsmFallbackLanguage.orElse(null);
    }

    @JsonProperty(value="hsmFallbackLanguage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getHsmFallbackLanguage_JsonNullable() {
        return this.hsmFallbackLanguage;
    }

    @JsonProperty(value="hsmFallbackLanguage")
    public void setHsmFallbackLanguage_JsonNullable(JsonNullable<String> hsmFallbackLanguage) {
        this.hsmFallbackLanguage = hsmFallbackLanguage;
    }

    public void setHsmFallbackLanguage(String hsmFallbackLanguage) {
        this.hsmFallbackLanguage = JsonNullable.of((Object)hsmFallbackLanguage);
    }

    public WhatsAppUpdateAllOf accountId(String accountId) {
        this.accountId = JsonNullable.of((Object)accountId);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="your_whatsApp_account_id", value="The business ID associated with the WhatsApp account. In combination with accountManagementAccessToken, it\u2019s used for Message Template Reconstruction.")
    @JsonIgnore
    public String getAccountId() {
        return (String)this.accountId.orElse(null);
    }

    @JsonProperty(value="accountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getAccountId_JsonNullable() {
        return this.accountId;
    }

    @JsonProperty(value="accountId")
    public void setAccountId_JsonNullable(JsonNullable<String> accountId) {
        this.accountId = accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = JsonNullable.of((Object)accountId);
    }

    public WhatsAppUpdateAllOf accountManagementAccessToken(String accountManagementAccessToken) {
        this.accountManagementAccessToken = JsonNullable.of((Object)accountManagementAccessToken);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="your_access_token", value="An access token associated with the accountId used to query the WhatsApp Account Management API. In combination with accountId, it\u2019s used for Message Template Reconstruction.")
    @JsonIgnore
    public String getAccountManagementAccessToken() {
        return (String)this.accountManagementAccessToken.orElse(null);
    }

    @JsonProperty(value="accountManagementAccessToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getAccountManagementAccessToken_JsonNullable() {
        return this.accountManagementAccessToken;
    }

    @JsonProperty(value="accountManagementAccessToken")
    public void setAccountManagementAccessToken_JsonNullable(JsonNullable<String> accountManagementAccessToken) {
        this.accountManagementAccessToken = accountManagementAccessToken;
    }

    public void setAccountManagementAccessToken(String accountManagementAccessToken) {
        this.accountManagementAccessToken = JsonNullable.of((Object)accountManagementAccessToken);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WhatsAppUpdateAllOf whatsAppUpdateAllOf = (WhatsAppUpdateAllOf)o;
        return Objects.equals(this.hsmFallbackLanguage, whatsAppUpdateAllOf.hsmFallbackLanguage) && Objects.equals(this.accountId, whatsAppUpdateAllOf.accountId) && Objects.equals(this.accountManagementAccessToken, whatsAppUpdateAllOf.accountManagementAccessToken);
    }

    public int hashCode() {
        return Objects.hash(this.hsmFallbackLanguage, this.accountId, this.accountManagementAccessToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WhatsAppUpdateAllOf {\n");
        sb.append("    hsmFallbackLanguage: ").append(this.toIndentedString(this.hsmFallbackLanguage)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    accountManagementAccessToken: ").append(this.toIndentedString(this.accountManagementAccessToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

