/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.zendesk.sunshine_conversations_client.model.Android;
import com.zendesk.sunshine_conversations_client.model.Apple;
import com.zendesk.sunshine_conversations_client.model.Custom;
import com.zendesk.sunshine_conversations_client.model.DefaultResponderDefaultResponder;
import com.zendesk.sunshine_conversations_client.model.Instagram;
import com.zendesk.sunshine_conversations_client.model.Integration;
import com.zendesk.sunshine_conversations_client.model.Ios;
import com.zendesk.sunshine_conversations_client.model.Line;
import com.zendesk.sunshine_conversations_client.model.Mailgun;
import com.zendesk.sunshine_conversations_client.model.Messagebird;
import com.zendesk.sunshine_conversations_client.model.Messenger;
import com.zendesk.sunshine_conversations_client.model.Telegram;
import com.zendesk.sunshine_conversations_client.model.Twilio;
import com.zendesk.sunshine_conversations_client.model.Twitter;
import com.zendesk.sunshine_conversations_client.model.Unity;
import com.zendesk.sunshine_conversations_client.model.Viber;
import com.zendesk.sunshine_conversations_client.model.Web;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"type", "hsmFallbackLanguage", "accountId", "accountManagementAccessToken", "phoneNumber", "defaultResponderId", "defaultResponder"})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=Android.class, name="android"), @JsonSubTypes.Type(value=Apple.class, name="apple"), @JsonSubTypes.Type(value=Custom.class, name="custom"), @JsonSubTypes.Type(value=Instagram.class, name="instagram"), @JsonSubTypes.Type(value=Ios.class, name="ios"), @JsonSubTypes.Type(value=Line.class, name="line"), @JsonSubTypes.Type(value=Mailgun.class, name="mailgun"), @JsonSubTypes.Type(value=Messagebird.class, name="messagebird"), @JsonSubTypes.Type(value=Messenger.class, name="messenger"), @JsonSubTypes.Type(value=Telegram.class, name="telegram"), @JsonSubTypes.Type(value=Twilio.class, name="twilio"), @JsonSubTypes.Type(value=Twitter.class, name="twitter"), @JsonSubTypes.Type(value=Unity.class, name="unity"), @JsonSubTypes.Type(value=Viber.class, name="viber"), @JsonSubTypes.Type(value=Web.class, name="web"), @JsonSubTypes.Type(value=Whatsapp.class, name="whatsapp")})
public class Whatsapp
extends Integration {
    public static final String JSON_PROPERTY_TYPE = "type";
    protected String type = "whatsapp";
    public static final String JSON_PROPERTY_HSM_FALLBACK_LANGUAGE = "hsmFallbackLanguage";
    private JsonNullable<String> hsmFallbackLanguage = JsonNullable.of((Object)"en_US");
    public static final String JSON_PROPERTY_ACCOUNT_ID = "accountId";
    private JsonNullable<String> accountId = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ACCOUNT_MANAGEMENT_ACCESS_TOKEN = "accountManagementAccessToken";
    private JsonNullable<String> accountManagementAccessToken = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PHONE_NUMBER = "phoneNumber";
    private JsonNullable<String> phoneNumber = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DEFAULT_RESPONDER_ID = "defaultResponderId";
    private JsonNullable<String> defaultResponderId = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DEFAULT_RESPONDER = "defaultResponder";
    private JsonNullable<DefaultResponderDefaultResponder> defaultResponder = JsonNullable.undefined();

    @Override
    public Whatsapp type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @Nullable
    @ApiModelProperty(value="To configure a WhatsApp integration, use your WhatsApp API Client connection information. Sunshine Conversations can provide WhatsApp API Client hosting for approved brands. See our [WhatsApp guide](https://docs.smooch.io/guide/whatsapp/#whatsapp-api-client) for more details on WhatsApp API Client hosting. ")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public Whatsapp hsmFallbackLanguage(String hsmFallbackLanguage) {
        this.hsmFallbackLanguage = JsonNullable.of((Object)hsmFallbackLanguage);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specify a fallback language to use when sending WhatsApp message template using the short hand syntax. Defaults to en_US. See WhatsApp documentation for more info.")
    @JsonIgnore
    public String getHsmFallbackLanguage() {
        return (String)this.hsmFallbackLanguage.orElse(null);
    }

    @JsonProperty(value="hsmFallbackLanguage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getHsmFallbackLanguage_JsonNullable() {
        return this.hsmFallbackLanguage;
    }

    @JsonProperty(value="hsmFallbackLanguage")
    public void setHsmFallbackLanguage_JsonNullable(JsonNullable<String> hsmFallbackLanguage) {
        this.hsmFallbackLanguage = hsmFallbackLanguage;
    }

    public void setHsmFallbackLanguage(String hsmFallbackLanguage) {
        this.hsmFallbackLanguage = JsonNullable.of((Object)hsmFallbackLanguage);
    }

    public Whatsapp accountId(String accountId) {
        this.accountId = JsonNullable.of((Object)accountId);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="your_whatsApp_account_id", value="The business ID associated with the WhatsApp account. In combination with accountManagementAccessToken, it\u2019s used for Message Template Reconstruction.")
    @JsonIgnore
    public String getAccountId() {
        return (String)this.accountId.orElse(null);
    }

    @JsonProperty(value="accountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getAccountId_JsonNullable() {
        return this.accountId;
    }

    @JsonProperty(value="accountId")
    public void setAccountId_JsonNullable(JsonNullable<String> accountId) {
        this.accountId = accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = JsonNullable.of((Object)accountId);
    }

    public Whatsapp accountManagementAccessToken(String accountManagementAccessToken) {
        this.accountManagementAccessToken = JsonNullable.of((Object)accountManagementAccessToken);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="your_access_token", value="An access token associated with the accountId used to query the WhatsApp Account Management API. In combination with accountId, it\u2019s used for Message Template Reconstruction.")
    @JsonIgnore
    public String getAccountManagementAccessToken() {
        return (String)this.accountManagementAccessToken.orElse(null);
    }

    @JsonProperty(value="accountManagementAccessToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getAccountManagementAccessToken_JsonNullable() {
        return this.accountManagementAccessToken;
    }

    @JsonProperty(value="accountManagementAccessToken")
    public void setAccountManagementAccessToken_JsonNullable(JsonNullable<String> accountManagementAccessToken) {
        this.accountManagementAccessToken = accountManagementAccessToken;
    }

    public void setAccountManagementAccessToken(String accountManagementAccessToken) {
        this.accountManagementAccessToken = JsonNullable.of((Object)accountManagementAccessToken);
    }

    @Nullable
    @ApiModelProperty(example="15144441919", value="The phone number that is associated with the deployment of this integration, if one exists.")
    @JsonIgnore
    public String getPhoneNumber() {
        if (this.phoneNumber == null) {
            this.phoneNumber = JsonNullable.undefined();
        }
        return (String)this.phoneNumber.orElse(null);
    }

    @JsonProperty(value="phoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getPhoneNumber_JsonNullable() {
        return this.phoneNumber;
    }

    @JsonProperty(value="phoneNumber")
    private void setPhoneNumber_JsonNullable(JsonNullable<String> phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public Whatsapp defaultResponderId(String defaultResponderId) {
        this.defaultResponderId = JsonNullable.of((Object)defaultResponderId);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The default responder ID for the integration. This is the ID of the responder that will be used to send messages to the user. For more information, refer to the <a href=\"https://developer.zendesk.com/documentation/conversations/messaging-platform/programmable-conversations/switchboard/#default-integration-assignment\">Switchboard guide</a>. ")
    @JsonIgnore
    public String getDefaultResponderId() {
        return (String)this.defaultResponderId.orElse(null);
    }

    @JsonProperty(value="defaultResponderId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDefaultResponderId_JsonNullable() {
        return this.defaultResponderId;
    }

    @JsonProperty(value="defaultResponderId")
    public void setDefaultResponderId_JsonNullable(JsonNullable<String> defaultResponderId) {
        this.defaultResponderId = defaultResponderId;
    }

    public void setDefaultResponderId(String defaultResponderId) {
        this.defaultResponderId = JsonNullable.of((Object)defaultResponderId);
    }

    public Whatsapp defaultResponder(DefaultResponderDefaultResponder defaultResponder) {
        this.defaultResponder = JsonNullable.of((Object)defaultResponder);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public DefaultResponderDefaultResponder getDefaultResponder() {
        return (DefaultResponderDefaultResponder)this.defaultResponder.orElse(null);
    }

    @JsonProperty(value="defaultResponder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<DefaultResponderDefaultResponder> getDefaultResponder_JsonNullable() {
        return this.defaultResponder;
    }

    @JsonProperty(value="defaultResponder")
    public void setDefaultResponder_JsonNullable(JsonNullable<DefaultResponderDefaultResponder> defaultResponder) {
        this.defaultResponder = defaultResponder;
    }

    public void setDefaultResponder(DefaultResponderDefaultResponder defaultResponder) {
        this.defaultResponder = JsonNullable.of((Object)defaultResponder);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Whatsapp whatsapp = (Whatsapp)o;
        return Objects.equals(this.type, whatsapp.type) && Objects.equals(this.hsmFallbackLanguage, whatsapp.hsmFallbackLanguage) && Objects.equals(this.accountId, whatsapp.accountId) && Objects.equals(this.accountManagementAccessToken, whatsapp.accountManagementAccessToken) && Objects.equals(this.phoneNumber, whatsapp.phoneNumber) && Objects.equals(this.defaultResponderId, whatsapp.defaultResponderId) && Objects.equals(this.defaultResponder, whatsapp.defaultResponder) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type, this.hsmFallbackLanguage, this.accountId, this.accountManagementAccessToken, this.phoneNumber, this.defaultResponderId, this.defaultResponder, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Whatsapp {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    hsmFallbackLanguage: ").append(this.toIndentedString(this.hsmFallbackLanguage)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    accountManagementAccessToken: ").append(this.toIndentedString(this.accountManagementAccessToken)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    defaultResponderId: ").append(this.toIndentedString(this.defaultResponderId)).append("\n");
        sb.append("    defaultResponder: ").append(this.toIndentedString(this.defaultResponder)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

