/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.api;

import com.zendesk.sunshine_conversations_client.ApiClient;
import com.zendesk.sunshine_conversations_client.ApiException;
import com.zendesk.sunshine_conversations_client.Configuration;
import com.zendesk.sunshine_conversations_client.Pair;
import com.zendesk.sunshine_conversations_client.model.ClientCreate;
import com.zendesk.sunshine_conversations_client.model.ClientListResponse;
import com.zendesk.sunshine_conversations_client.model.ClientResponse;
import com.zendesk.sunshine_conversations_client.model.Page;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class ClientsApi {
    private ApiClient apiClient;

    public ClientsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ClientsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ClientResponse createClient(ClientCreate clientCreate, String appId, String userIdOrExternalId) throws ApiException {
        ClientCreate localVarPostBody = clientCreate;
        if (clientCreate == null) {
            throw new ApiException(400, "Missing the required parameter 'clientCreate' when calling createClient");
        }
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling createClient");
        }
        if (userIdOrExternalId == null) {
            throw new ApiException(400, "Missing the required parameter 'userIdOrExternalId' when calling createClient");
        }
        String localVarPath = "/v2/apps/{appId}/users/{userIdOrExternalId}/clients".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{userIdOrExternalId\\}", this.apiClient.escapeString(userIdOrExternalId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<ClientResponse> localVarReturnType = new GenericType<ClientResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ClientListResponse listClients(String appId, String userIdOrExternalId, Page page) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling listClients");
        }
        if (userIdOrExternalId == null) {
            throw new ApiException(400, "Missing the required parameter 'userIdOrExternalId' when calling listClients");
        }
        String localVarPath = "/v2/apps/{appId}/users/{userIdOrExternalId}/clients".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{userIdOrExternalId\\}", this.apiClient.escapeString(userIdOrExternalId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page", page));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<ClientListResponse> localVarReturnType = new GenericType<ClientListResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Object removeClient(String appId, String userIdOrExternalId, String clientId) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling removeClient");
        }
        if (userIdOrExternalId == null) {
            throw new ApiException(400, "Missing the required parameter 'userIdOrExternalId' when calling removeClient");
        }
        if (clientId == null) {
            throw new ApiException(400, "Missing the required parameter 'clientId' when calling removeClient");
        }
        String localVarPath = "/v2/apps/{appId}/users/{userIdOrExternalId}/clients/{clientId}".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{userIdOrExternalId\\}", this.apiClient.escapeString(userIdOrExternalId.toString())).replaceAll("\\{clientId\\}", this.apiClient.escapeString(clientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ClientResponse createClient(String bearerToken, ClientCreate clientCreate, String appId, String userIdOrExternalId) throws ApiException {
        ClientCreate localVarPostBody = clientCreate;
        if (clientCreate == null) {
            throw new ApiException(400, "Missing the required parameter 'clientCreate' when calling createClient");
        }
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling createClient");
        }
        if (userIdOrExternalId == null) {
            throw new ApiException(400, "Missing the required parameter 'userIdOrExternalId' when calling createClient");
        }
        String localVarPath = "/v2/apps/{appId}/users/{userIdOrExternalId}/clients".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{userIdOrExternalId\\}", this.apiClient.escapeString(userIdOrExternalId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Authorization", "Bearer " + bearerToken);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<ClientResponse> localVarReturnType = new GenericType<ClientResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ClientListResponse listClients(String bearerToken, String appId, String userIdOrExternalId, Page page) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling listClients");
        }
        if (userIdOrExternalId == null) {
            throw new ApiException(400, "Missing the required parameter 'userIdOrExternalId' when calling listClients");
        }
        String localVarPath = "/v2/apps/{appId}/users/{userIdOrExternalId}/clients".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{userIdOrExternalId\\}", this.apiClient.escapeString(userIdOrExternalId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page", page));
        localVarHeaderParams.put("Authorization", "Bearer " + bearerToken);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<ClientListResponse> localVarReturnType = new GenericType<ClientListResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Object removeClient(String bearerToken, String appId, String userIdOrExternalId, String clientId) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling removeClient");
        }
        if (userIdOrExternalId == null) {
            throw new ApiException(400, "Missing the required parameter 'userIdOrExternalId' when calling removeClient");
        }
        if (clientId == null) {
            throw new ApiException(400, "Missing the required parameter 'clientId' when calling removeClient");
        }
        String localVarPath = "/v2/apps/{appId}/users/{userIdOrExternalId}/clients/{clientId}".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{userIdOrExternalId\\}", this.apiClient.escapeString(userIdOrExternalId.toString())).replaceAll("\\{clientId\\}", this.apiClient.escapeString(clientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Authorization", "Bearer " + bearerToken);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

