/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.api;

import com.zendesk.sunshine_conversations_client.ApiClient;
import com.zendesk.sunshine_conversations_client.ApiException;
import com.zendesk.sunshine_conversations_client.Configuration;
import com.zendesk.sunshine_conversations_client.Pair;
import com.zendesk.sunshine_conversations_client.model.IntegrationApiKey;
import com.zendesk.sunshine_conversations_client.model.IntegrationApiKeyListResponse;
import com.zendesk.sunshine_conversations_client.model.IntegrationApiKeyResponse;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class CustomIntegrationApiKeysApi {
    private ApiClient apiClient;

    public CustomIntegrationApiKeysApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CustomIntegrationApiKeysApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public IntegrationApiKeyResponse createCustomIntegrationKey(IntegrationApiKey integrationApiKey, String appId, String integrationId) throws ApiException {
        IntegrationApiKey localVarPostBody = integrationApiKey;
        if (integrationApiKey == null) {
            throw new ApiException(400, "Missing the required parameter 'integrationApiKey' when calling createCustomIntegrationKey");
        }
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling createCustomIntegrationKey");
        }
        if (integrationId == null) {
            throw new ApiException(400, "Missing the required parameter 'integrationId' when calling createCustomIntegrationKey");
        }
        String localVarPath = "/v2/apps/{appId}/integrations/{integrationId}/keys".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{integrationId\\}", this.apiClient.escapeString(integrationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<IntegrationApiKeyResponse> localVarReturnType = new GenericType<IntegrationApiKeyResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Object deleteCustomIntegrationKey(String appId, String integrationId, String keyId) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling deleteCustomIntegrationKey");
        }
        if (integrationId == null) {
            throw new ApiException(400, "Missing the required parameter 'integrationId' when calling deleteCustomIntegrationKey");
        }
        if (keyId == null) {
            throw new ApiException(400, "Missing the required parameter 'keyId' when calling deleteCustomIntegrationKey");
        }
        String localVarPath = "/v2/apps/{appId}/integrations/{integrationId}/keys/{keyId}".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{integrationId\\}", this.apiClient.escapeString(integrationId.toString())).replaceAll("\\{keyId\\}", this.apiClient.escapeString(keyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public IntegrationApiKeyResponse getCustomIntegrationKey(String appId, String integrationId, String keyId) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling getCustomIntegrationKey");
        }
        if (integrationId == null) {
            throw new ApiException(400, "Missing the required parameter 'integrationId' when calling getCustomIntegrationKey");
        }
        if (keyId == null) {
            throw new ApiException(400, "Missing the required parameter 'keyId' when calling getCustomIntegrationKey");
        }
        String localVarPath = "/v2/apps/{appId}/integrations/{integrationId}/keys/{keyId}".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{integrationId\\}", this.apiClient.escapeString(integrationId.toString())).replaceAll("\\{keyId\\}", this.apiClient.escapeString(keyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<IntegrationApiKeyResponse> localVarReturnType = new GenericType<IntegrationApiKeyResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public IntegrationApiKeyListResponse listCustomIntegrationKeys(String appId, String integrationId) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling listCustomIntegrationKeys");
        }
        if (integrationId == null) {
            throw new ApiException(400, "Missing the required parameter 'integrationId' when calling listCustomIntegrationKeys");
        }
        String localVarPath = "/v2/apps/{appId}/integrations/{integrationId}/keys".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{integrationId\\}", this.apiClient.escapeString(integrationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<IntegrationApiKeyListResponse> localVarReturnType = new GenericType<IntegrationApiKeyListResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public IntegrationApiKeyResponse createCustomIntegrationKey(String bearerToken, IntegrationApiKey integrationApiKey, String appId, String integrationId) throws ApiException {
        IntegrationApiKey localVarPostBody = integrationApiKey;
        if (integrationApiKey == null) {
            throw new ApiException(400, "Missing the required parameter 'integrationApiKey' when calling createCustomIntegrationKey");
        }
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling createCustomIntegrationKey");
        }
        if (integrationId == null) {
            throw new ApiException(400, "Missing the required parameter 'integrationId' when calling createCustomIntegrationKey");
        }
        String localVarPath = "/v2/apps/{appId}/integrations/{integrationId}/keys".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{integrationId\\}", this.apiClient.escapeString(integrationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Authorization", "Bearer " + bearerToken);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<IntegrationApiKeyResponse> localVarReturnType = new GenericType<IntegrationApiKeyResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Object deleteCustomIntegrationKey(String bearerToken, String appId, String integrationId, String keyId) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling deleteCustomIntegrationKey");
        }
        if (integrationId == null) {
            throw new ApiException(400, "Missing the required parameter 'integrationId' when calling deleteCustomIntegrationKey");
        }
        if (keyId == null) {
            throw new ApiException(400, "Missing the required parameter 'keyId' when calling deleteCustomIntegrationKey");
        }
        String localVarPath = "/v2/apps/{appId}/integrations/{integrationId}/keys/{keyId}".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{integrationId\\}", this.apiClient.escapeString(integrationId.toString())).replaceAll("\\{keyId\\}", this.apiClient.escapeString(keyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Authorization", "Bearer " + bearerToken);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public IntegrationApiKeyResponse getCustomIntegrationKey(String bearerToken, String appId, String integrationId, String keyId) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling getCustomIntegrationKey");
        }
        if (integrationId == null) {
            throw new ApiException(400, "Missing the required parameter 'integrationId' when calling getCustomIntegrationKey");
        }
        if (keyId == null) {
            throw new ApiException(400, "Missing the required parameter 'keyId' when calling getCustomIntegrationKey");
        }
        String localVarPath = "/v2/apps/{appId}/integrations/{integrationId}/keys/{keyId}".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{integrationId\\}", this.apiClient.escapeString(integrationId.toString())).replaceAll("\\{keyId\\}", this.apiClient.escapeString(keyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Authorization", "Bearer " + bearerToken);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<IntegrationApiKeyResponse> localVarReturnType = new GenericType<IntegrationApiKeyResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public IntegrationApiKeyListResponse listCustomIntegrationKeys(String bearerToken, String appId, String integrationId) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling listCustomIntegrationKeys");
        }
        if (integrationId == null) {
            throw new ApiException(400, "Missing the required parameter 'integrationId' when calling listCustomIntegrationKeys");
        }
        String localVarPath = "/v2/apps/{appId}/integrations/{integrationId}/keys".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{integrationId\\}", this.apiClient.escapeString(integrationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Authorization", "Bearer " + bearerToken);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<IntegrationApiKeyListResponse> localVarReturnType = new GenericType<IntegrationApiKeyListResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

