/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.api;

import com.zendesk.sunshine_conversations_client.ApiClient;
import com.zendesk.sunshine_conversations_client.ApiException;
import com.zendesk.sunshine_conversations_client.Configuration;
import com.zendesk.sunshine_conversations_client.Pair;
import com.zendesk.sunshine_conversations_client.model.SwitchboardIntegrationCreateBody;
import com.zendesk.sunshine_conversations_client.model.SwitchboardIntegrationListResponse;
import com.zendesk.sunshine_conversations_client.model.SwitchboardIntegrationResponse;
import com.zendesk.sunshine_conversations_client.model.SwitchboardIntegrationUpdateBody;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class SwitchboardIntegrationsApi {
    private ApiClient apiClient;

    public SwitchboardIntegrationsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SwitchboardIntegrationsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public SwitchboardIntegrationResponse createSwitchboardIntegration(SwitchboardIntegrationCreateBody switchboardIntegrationCreateBody, String appId, String switchboardId) throws ApiException {
        SwitchboardIntegrationCreateBody localVarPostBody = switchboardIntegrationCreateBody;
        if (switchboardIntegrationCreateBody == null) {
            throw new ApiException(400, "Missing the required parameter 'switchboardIntegrationCreateBody' when calling createSwitchboardIntegration");
        }
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling createSwitchboardIntegration");
        }
        if (switchboardId == null) {
            throw new ApiException(400, "Missing the required parameter 'switchboardId' when calling createSwitchboardIntegration");
        }
        String localVarPath = "/v2/apps/{appId}/switchboards/{switchboardId}/switchboardIntegrations".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{switchboardId\\}", this.apiClient.escapeString(switchboardId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<SwitchboardIntegrationResponse> localVarReturnType = new GenericType<SwitchboardIntegrationResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Object deleteSwitchboardIntegration(String appId, String switchboardId, String switchboardIntegrationId) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling deleteSwitchboardIntegration");
        }
        if (switchboardId == null) {
            throw new ApiException(400, "Missing the required parameter 'switchboardId' when calling deleteSwitchboardIntegration");
        }
        if (switchboardIntegrationId == null) {
            throw new ApiException(400, "Missing the required parameter 'switchboardIntegrationId' when calling deleteSwitchboardIntegration");
        }
        String localVarPath = "/v2/apps/{appId}/switchboards/{switchboardId}/switchboardIntegrations/{switchboardIntegrationId}".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{switchboardId\\}", this.apiClient.escapeString(switchboardId.toString())).replaceAll("\\{switchboardIntegrationId\\}", this.apiClient.escapeString(switchboardIntegrationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public SwitchboardIntegrationListResponse listSwitchboardIntegrations(String appId, String switchboardId) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling listSwitchboardIntegrations");
        }
        if (switchboardId == null) {
            throw new ApiException(400, "Missing the required parameter 'switchboardId' when calling listSwitchboardIntegrations");
        }
        String localVarPath = "/v2/apps/{appId}/switchboards/{switchboardId}/switchboardIntegrations".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{switchboardId\\}", this.apiClient.escapeString(switchboardId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<SwitchboardIntegrationListResponse> localVarReturnType = new GenericType<SwitchboardIntegrationListResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public SwitchboardIntegrationResponse updateSwitchboardIntegration(SwitchboardIntegrationUpdateBody switchboardIntegrationUpdateBody, String appId, String switchboardId, String switchboardIntegrationId) throws ApiException {
        SwitchboardIntegrationUpdateBody localVarPostBody = switchboardIntegrationUpdateBody;
        if (switchboardIntegrationUpdateBody == null) {
            throw new ApiException(400, "Missing the required parameter 'switchboardIntegrationUpdateBody' when calling updateSwitchboardIntegration");
        }
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling updateSwitchboardIntegration");
        }
        if (switchboardId == null) {
            throw new ApiException(400, "Missing the required parameter 'switchboardId' when calling updateSwitchboardIntegration");
        }
        if (switchboardIntegrationId == null) {
            throw new ApiException(400, "Missing the required parameter 'switchboardIntegrationId' when calling updateSwitchboardIntegration");
        }
        String localVarPath = "/v2/apps/{appId}/switchboards/{switchboardId}/switchboardIntegrations/{switchboardIntegrationId}".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{switchboardId\\}", this.apiClient.escapeString(switchboardId.toString())).replaceAll("\\{switchboardIntegrationId\\}", this.apiClient.escapeString(switchboardIntegrationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<SwitchboardIntegrationResponse> localVarReturnType = new GenericType<SwitchboardIntegrationResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public SwitchboardIntegrationResponse createSwitchboardIntegration(String bearerToken, SwitchboardIntegrationCreateBody switchboardIntegrationCreateBody, String appId, String switchboardId) throws ApiException {
        SwitchboardIntegrationCreateBody localVarPostBody = switchboardIntegrationCreateBody;
        if (switchboardIntegrationCreateBody == null) {
            throw new ApiException(400, "Missing the required parameter 'switchboardIntegrationCreateBody' when calling createSwitchboardIntegration");
        }
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling createSwitchboardIntegration");
        }
        if (switchboardId == null) {
            throw new ApiException(400, "Missing the required parameter 'switchboardId' when calling createSwitchboardIntegration");
        }
        String localVarPath = "/v2/apps/{appId}/switchboards/{switchboardId}/switchboardIntegrations".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{switchboardId\\}", this.apiClient.escapeString(switchboardId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Authorization", "Bearer " + bearerToken);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<SwitchboardIntegrationResponse> localVarReturnType = new GenericType<SwitchboardIntegrationResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Object deleteSwitchboardIntegration(String bearerToken, String appId, String switchboardId, String switchboardIntegrationId) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling deleteSwitchboardIntegration");
        }
        if (switchboardId == null) {
            throw new ApiException(400, "Missing the required parameter 'switchboardId' when calling deleteSwitchboardIntegration");
        }
        if (switchboardIntegrationId == null) {
            throw new ApiException(400, "Missing the required parameter 'switchboardIntegrationId' when calling deleteSwitchboardIntegration");
        }
        String localVarPath = "/v2/apps/{appId}/switchboards/{switchboardId}/switchboardIntegrations/{switchboardIntegrationId}".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{switchboardId\\}", this.apiClient.escapeString(switchboardId.toString())).replaceAll("\\{switchboardIntegrationId\\}", this.apiClient.escapeString(switchboardIntegrationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Authorization", "Bearer " + bearerToken);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public SwitchboardIntegrationListResponse listSwitchboardIntegrations(String bearerToken, String appId, String switchboardId) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling listSwitchboardIntegrations");
        }
        if (switchboardId == null) {
            throw new ApiException(400, "Missing the required parameter 'switchboardId' when calling listSwitchboardIntegrations");
        }
        String localVarPath = "/v2/apps/{appId}/switchboards/{switchboardId}/switchboardIntegrations".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{switchboardId\\}", this.apiClient.escapeString(switchboardId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Authorization", "Bearer " + bearerToken);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<SwitchboardIntegrationListResponse> localVarReturnType = new GenericType<SwitchboardIntegrationListResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public SwitchboardIntegrationResponse updateSwitchboardIntegration(String bearerToken, SwitchboardIntegrationUpdateBody switchboardIntegrationUpdateBody, String appId, String switchboardId, String switchboardIntegrationId) throws ApiException {
        SwitchboardIntegrationUpdateBody localVarPostBody = switchboardIntegrationUpdateBody;
        if (switchboardIntegrationUpdateBody == null) {
            throw new ApiException(400, "Missing the required parameter 'switchboardIntegrationUpdateBody' when calling updateSwitchboardIntegration");
        }
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling updateSwitchboardIntegration");
        }
        if (switchboardId == null) {
            throw new ApiException(400, "Missing the required parameter 'switchboardId' when calling updateSwitchboardIntegration");
        }
        if (switchboardIntegrationId == null) {
            throw new ApiException(400, "Missing the required parameter 'switchboardIntegrationId' when calling updateSwitchboardIntegration");
        }
        String localVarPath = "/v2/apps/{appId}/switchboards/{switchboardId}/switchboardIntegrations/{switchboardIntegrationId}".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{switchboardId\\}", this.apiClient.escapeString(switchboardId.toString())).replaceAll("\\{switchboardIntegrationId\\}", this.apiClient.escapeString(switchboardIntegrationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Authorization", "Bearer " + bearerToken);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<SwitchboardIntegrationResponse> localVarReturnType = new GenericType<SwitchboardIntegrationResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

