/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.zendesk.sunshine_conversations_client.model.ConversationTruncated;
import com.zendesk.sunshine_conversations_client.model.Referral;
import com.zendesk.sunshine_conversations_client.model.SourceWebhook;
import com.zendesk.sunshine_conversations_client.model.User;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="The payload of the event. The contents of this object depend on the type of event.")
@JsonPropertyOrder(value={"conversation", "creationReason", "source", "user", "referral"})
public class ConversationCreateEventAllOfPayload {
    public static final String JSON_PROPERTY_CONVERSATION = "conversation";
    private ConversationTruncated conversation = null;
    public static final String JSON_PROPERTY_CREATION_REASON = "creationReason";
    private CreationReasonEnum creationReason;
    public static final String JSON_PROPERTY_SOURCE = "source";
    private SourceWebhook source = null;
    public static final String JSON_PROPERTY_USER = "user";
    private JsonNullable<User> user = JsonNullable.of(null);
    public static final String JSON_PROPERTY_REFERRAL = "referral";
    private JsonNullable<Referral> referral = JsonNullable.of(null);

    public ConversationCreateEventAllOfPayload conversation(ConversationTruncated conversation) {
        this.conversation = conversation;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The conversation that was created.")
    @JsonProperty(value="conversation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ConversationTruncated getConversation() {
        return this.conversation;
    }

    public void setConversation(ConversationTruncated conversation) {
        this.conversation = conversation;
    }

    public ConversationCreateEventAllOfPayload creationReason(CreationReasonEnum creationReason) {
        this.creationReason = creationReason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The reason why the conversation was created, if applicable. * `linkRequest` - The conversation was created in order to generate a link request to transfer the user to a different channel. * `message` - The conversation was created because a message was sent. * `none` - The conversation was not created for a specific purpose. Used primarily when a conversation is created via the Create Conversation API. * `notification` - The conversation was created by a call to the Notification API. * `prechatCapture` - The conversation was created because the user completed a prechat capture form in the Web Messenger. * `startConversation` - The conversation was created because of a call to the startConversation API on one of the SDK integrations, or a start conversation event was triggered from a messaging channel. ")
    @JsonProperty(value="creationReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CreationReasonEnum getCreationReason() {
        return this.creationReason;
    }

    public void setCreationReason(CreationReasonEnum creationReason) {
        this.creationReason = creationReason;
    }

    public ConversationCreateEventAllOfPayload source(SourceWebhook source) {
        this.source = source;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The source of the creation.")
    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SourceWebhook getSource() {
        return this.source;
    }

    public void setSource(SourceWebhook source) {
        this.source = source;
    }

    public ConversationCreateEventAllOfPayload user(User user) {
        this.user = JsonNullable.of((Object)user);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The user associated with the conversation. Only present if the created conversation was of type personal. For sdkGroup conversations, the list of participants can be fetched using the List Participants API, if required.")
    @JsonIgnore
    public User getUser() {
        return (User)this.user.orElse(null);
    }

    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<User> getUser_JsonNullable() {
        return this.user;
    }

    @JsonProperty(value="user")
    public void setUser_JsonNullable(JsonNullable<User> user) {
        this.user = user;
    }

    public void setUser(User user) {
        this.user = JsonNullable.of((Object)user);
    }

    public ConversationCreateEventAllOfPayload referral(Referral referral) {
        this.referral = JsonNullable.of((Object)referral);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Referral information, if applicable.")
    @JsonIgnore
    public Referral getReferral() {
        return (Referral)this.referral.orElse(null);
    }

    @JsonProperty(value="referral")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Referral> getReferral_JsonNullable() {
        return this.referral;
    }

    @JsonProperty(value="referral")
    public void setReferral_JsonNullable(JsonNullable<Referral> referral) {
        this.referral = referral;
    }

    public void setReferral(Referral referral) {
        this.referral = JsonNullable.of((Object)referral);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationCreateEventAllOfPayload conversationCreateEventAllOfPayload = (ConversationCreateEventAllOfPayload)o;
        return Objects.equals(this.conversation, conversationCreateEventAllOfPayload.conversation) && Objects.equals((Object)this.creationReason, (Object)conversationCreateEventAllOfPayload.creationReason) && Objects.equals(this.source, conversationCreateEventAllOfPayload.source) && Objects.equals(this.user, conversationCreateEventAllOfPayload.user) && Objects.equals(this.referral, conversationCreateEventAllOfPayload.referral);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.conversation, this.creationReason, this.source, this.user, this.referral});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationCreateEventAllOfPayload {\n");
        sb.append("    conversation: ").append(this.toIndentedString(this.conversation)).append("\n");
        sb.append("    creationReason: ").append(this.toIndentedString((Object)this.creationReason)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    referral: ").append(this.toIndentedString(this.referral)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CreationReasonEnum {
        LINKREQUEST("linkRequest"),
        MESSAGE("message"),
        NONE("none"),
        NOTIFICATION("notification"),
        PRECHATCAPTURE("prechatCapture"),
        STARTCONVERSATION("startConversation");

        private String value;

        private CreationReasonEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CreationReasonEnum fromValue(String value) {
            for (CreationReasonEnum b : CreationReasonEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

