/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.ConversationTruncated;
import com.zendesk.sunshine_conversations_client.model.PostbackWebhook;
import com.zendesk.sunshine_conversations_client.model.SourceWebhook;
import com.zendesk.sunshine_conversations_client.model.User;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The payload of the event. The contents of this object depend on the type of event.")
@JsonPropertyOrder(value={"postback", "conversation", "user", "source"})
public class ConversationPostbackEventAllOfPayload {
    public static final String JSON_PROPERTY_POSTBACK = "postback";
    private PostbackWebhook postback = null;
    public static final String JSON_PROPERTY_CONVERSATION = "conversation";
    private ConversationTruncated conversation = null;
    public static final String JSON_PROPERTY_USER = "user";
    private User user = null;
    public static final String JSON_PROPERTY_SOURCE = "source";
    private SourceWebhook source = null;

    public ConversationPostbackEventAllOfPayload postback(PostbackWebhook postback) {
        this.postback = postback;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The postback associated with the event.")
    @JsonProperty(value="postback")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PostbackWebhook getPostback() {
        return this.postback;
    }

    public void setPostback(PostbackWebhook postback) {
        this.postback = postback;
    }

    public ConversationPostbackEventAllOfPayload conversation(ConversationTruncated conversation) {
        this.conversation = conversation;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The conversation linked to the postback.")
    @JsonProperty(value="conversation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ConversationTruncated getConversation() {
        return this.conversation;
    }

    public void setConversation(ConversationTruncated conversation) {
        this.conversation = conversation;
    }

    public ConversationPostbackEventAllOfPayload user(User user) {
        this.user = user;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The user that triggered the postback.")
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public ConversationPostbackEventAllOfPayload source(SourceWebhook source) {
        this.source = source;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The source of the postback.")
    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SourceWebhook getSource() {
        return this.source;
    }

    public void setSource(SourceWebhook source) {
        this.source = source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationPostbackEventAllOfPayload conversationPostbackEventAllOfPayload = (ConversationPostbackEventAllOfPayload)o;
        return Objects.equals(this.postback, conversationPostbackEventAllOfPayload.postback) && Objects.equals(this.conversation, conversationPostbackEventAllOfPayload.conversation) && Objects.equals(this.user, conversationPostbackEventAllOfPayload.user) && Objects.equals(this.source, conversationPostbackEventAllOfPayload.source);
    }

    public int hashCode() {
        return Objects.hash(this.postback, this.conversation, this.user, this.source);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationPostbackEventAllOfPayload {\n");
        sb.append("    postback: ").append(this.toIndentedString(this.postback)).append("\n");
        sb.append("    conversation: ").append(this.toIndentedString(this.conversation)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

