/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.AuthorWebhook;
import com.zendesk.sunshine_conversations_client.model.Content;
import com.zendesk.sunshine_conversations_client.model.QuotedMessage;
import com.zendesk.sunshine_conversations_client.model.Source;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"id", "received", "author", "content", "source", "quotedMessage", "metadata", "deleted"})
public class MessageWebhook {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_RECEIVED = "received";
    private String received;
    public static final String JSON_PROPERTY_AUTHOR = "author";
    private AuthorWebhook author;
    public static final String JSON_PROPERTY_CONTENT = "content";
    private Content content = null;
    public static final String JSON_PROPERTY_SOURCE = "source";
    private Source source;
    public static final String JSON_PROPERTY_QUOTED_MESSAGE = "quotedMessage";
    private JsonNullable<QuotedMessage> quotedMessage = JsonNullable.of(null);
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private JsonNullable<Object> metadata = JsonNullable.of(null);
    public static final String JSON_PROPERTY_DELETED = "deleted";
    private JsonNullable<Boolean> deleted = JsonNullable.undefined();

    public MessageWebhook id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="5e552ef595e5206375bb835d", value="The unique ID of the message.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public MessageWebhook received(String received) {
        this.received = received;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2019-03-21T18:48:52.760Z", value="A datetime string with the format `YYYY-MM-DDThh:mm:ss.SSSZ` representing when Sunshine Conversations received the message.")
    @JsonProperty(value="received")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReceived() {
        return this.received;
    }

    public void setReceived(String received) {
        this.received = received;
    }

    public MessageWebhook author(AuthorWebhook author) {
        this.author = author;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="author")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AuthorWebhook getAuthor() {
        return this.author;
    }

    public void setAuthor(AuthorWebhook author) {
        this.author = author;
    }

    public MessageWebhook content(Content content) {
        this.content = content;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The content of the message.")
    @JsonProperty(value="content")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Content getContent() {
        return this.content;
    }

    public void setContent(Content content) {
        this.content = content;
    }

    public MessageWebhook source(Source source) {
        this.source = source;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public MessageWebhook quotedMessage(QuotedMessage quotedMessage) {
        this.quotedMessage = JsonNullable.of((Object)quotedMessage);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The quoted message is currently only available for WhatsApp and Web Messenger `formResponse` messages.")
    @JsonIgnore
    public QuotedMessage getQuotedMessage() {
        return (QuotedMessage)this.quotedMessage.orElse(null);
    }

    @JsonProperty(value="quotedMessage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<QuotedMessage> getQuotedMessage_JsonNullable() {
        return this.quotedMessage;
    }

    @JsonProperty(value="quotedMessage")
    public void setQuotedMessage_JsonNullable(JsonNullable<QuotedMessage> quotedMessage) {
        this.quotedMessage = quotedMessage;
    }

    public void setQuotedMessage(QuotedMessage quotedMessage) {
        this.quotedMessage = JsonNullable.of((Object)quotedMessage);
    }

    public MessageWebhook metadata(Object metadata) {
        this.metadata = JsonNullable.of((Object)metadata);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Object getMetadata() {
        return this.metadata.orElse(null);
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Object> getMetadata_JsonNullable() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata_JsonNullable(JsonNullable<Object> metadata) {
        this.metadata = metadata;
    }

    public void setMetadata(Object metadata) {
        this.metadata = JsonNullable.of((Object)metadata);
    }

    public MessageWebhook deleted(Boolean deleted) {
        this.deleted = JsonNullable.of((Object)deleted);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="true if the message serves as a placeholder for one that has been deleted.")
    @JsonIgnore
    public Boolean getDeleted() {
        return (Boolean)this.deleted.orElse(null);
    }

    @JsonProperty(value="deleted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Boolean> getDeleted_JsonNullable() {
        return this.deleted;
    }

    @JsonProperty(value="deleted")
    public void setDeleted_JsonNullable(JsonNullable<Boolean> deleted) {
        this.deleted = deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = JsonNullable.of((Object)deleted);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageWebhook messageWebhook = (MessageWebhook)o;
        return Objects.equals(this.id, messageWebhook.id) && Objects.equals(this.received, messageWebhook.received) && Objects.equals(this.author, messageWebhook.author) && Objects.equals(this.content, messageWebhook.content) && Objects.equals(this.source, messageWebhook.source) && Objects.equals(this.quotedMessage, messageWebhook.quotedMessage) && Objects.equals(this.metadata, messageWebhook.metadata) && Objects.equals(this.deleted, messageWebhook.deleted);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.received, this.author, this.content, this.source, this.quotedMessage, this.metadata, this.deleted);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MessageWebhook {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    received: ").append(this.toIndentedString(this.received)).append("\n");
        sb.append("    author: ").append(this.toIndentedString(this.author)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    quotedMessage: ").append(this.toIndentedString(this.quotedMessage)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    deleted: ").append(this.toIndentedString(this.deleted)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

