/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"type", "tier", "envName", "consumerKey", "consumerSecret", "accessTokenKey", "accessTokenSecret"})
public class TwitterAllOf {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type = "twitter";
    public static final String JSON_PROPERTY_TIER = "tier";
    private TierEnum tier;
    public static final String JSON_PROPERTY_ENV_NAME = "envName";
    private String envName;
    public static final String JSON_PROPERTY_CONSUMER_KEY = "consumerKey";
    private String consumerKey;
    public static final String JSON_PROPERTY_CONSUMER_SECRET = "consumerSecret";
    private String consumerSecret;
    public static final String JSON_PROPERTY_ACCESS_TOKEN_KEY = "accessTokenKey";
    private String accessTokenKey;
    public static final String JSON_PROPERTY_ACCESS_TOKEN_SECRET = "accessTokenSecret";
    private String accessTokenSecret;

    public TwitterAllOf type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="To set up a Twitter integration, please follow the steps outlined in the [Twitter Setup Guide](https://docs.smooch.io/guide/twitter/#setup). ")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public TwitterAllOf tier(TierEnum tier) {
        this.tier = tier;
        return this;
    }

    @ApiModelProperty(required=true, value="Your Twitter app\u2019s tier, sandbox, premium or enterprise.")
    @JsonProperty(value="tier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TierEnum getTier() {
        return this.tier;
    }

    public void setTier(TierEnum tier) {
        this.tier = tier;
    }

    public TwitterAllOf envName(String envName) {
        this.envName = envName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="your_env_label", value="The Twitter dev environments label (required for sandbox and premium tiers).")
    @JsonProperty(value="envName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEnvName() {
        return this.envName;
    }

    public void setEnvName(String envName) {
        this.envName = envName;
    }

    public TwitterAllOf consumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
        return this;
    }

    @ApiModelProperty(example="your_consumer_key", required=true, value="The consumer key for your Twitter app.")
    @JsonProperty(value="consumerKey")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public TwitterAllOf consumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
        return this;
    }

    @ApiModelProperty(example="your_consumer_secret", required=true, value="The consumer key secret for your Twitter app.")
    @JsonProperty(value="consumerSecret")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    public TwitterAllOf accessTokenKey(String accessTokenKey) {
        this.accessTokenKey = accessTokenKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="your_access_token_key", value="The access token key obtained from your user via oauth.")
    @JsonProperty(value="accessTokenKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccessTokenKey() {
        return this.accessTokenKey;
    }

    public void setAccessTokenKey(String accessTokenKey) {
        this.accessTokenKey = accessTokenKey;
    }

    public TwitterAllOf accessTokenSecret(String accessTokenSecret) {
        this.accessTokenSecret = accessTokenSecret;
        return this;
    }

    @ApiModelProperty(example="your_access_token_secret", required=true, value="The access token secret obtained from your user via oauth.")
    @JsonProperty(value="accessTokenSecret")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAccessTokenSecret() {
        return this.accessTokenSecret;
    }

    public void setAccessTokenSecret(String accessTokenSecret) {
        this.accessTokenSecret = accessTokenSecret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TwitterAllOf twitterAllOf = (TwitterAllOf)o;
        return Objects.equals(this.type, twitterAllOf.type) && Objects.equals((Object)this.tier, (Object)twitterAllOf.tier) && Objects.equals(this.envName, twitterAllOf.envName) && Objects.equals(this.consumerKey, twitterAllOf.consumerKey) && Objects.equals(this.consumerSecret, twitterAllOf.consumerSecret) && Objects.equals(this.accessTokenKey, twitterAllOf.accessTokenKey) && Objects.equals(this.accessTokenSecret, twitterAllOf.accessTokenSecret);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.tier, this.envName, this.consumerKey, this.consumerSecret, this.accessTokenKey, this.accessTokenSecret});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TwitterAllOf {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    tier: ").append(this.toIndentedString((Object)this.tier)).append("\n");
        sb.append("    envName: ").append(this.toIndentedString(this.envName)).append("\n");
        sb.append("    consumerKey: ").append(this.toIndentedString(this.consumerKey)).append("\n");
        sb.append("    consumerSecret: ").append(this.toIndentedString(this.consumerSecret)).append("\n");
        sb.append("    accessTokenKey: ").append(this.toIndentedString(this.accessTokenKey)).append("\n");
        sb.append("    accessTokenSecret: ").append(this.toIndentedString(this.accessTokenSecret)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TierEnum {
        SANDBOX("sandbox"),
        PREMIUM("premium"),
        ENTERPRISE("enterprise");

        private String value;

        private TierEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TierEnum fromValue(String value) {
            for (TierEnum b : TierEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

