/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.api;

import com.zendesk.sunshine_conversations_client.ApiClient;
import com.zendesk.sunshine_conversations_client.ApiException;
import com.zendesk.sunshine_conversations_client.Configuration;
import com.zendesk.sunshine_conversations_client.Pair;
import com.zendesk.sunshine_conversations_client.model.SwitchboardListResponse;
import com.zendesk.sunshine_conversations_client.model.SwitchboardResponse;
import com.zendesk.sunshine_conversations_client.model.SwitchboardUpdateBody;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class SwitchboardsApi {
    private ApiClient apiClient;

    public SwitchboardsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SwitchboardsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public SwitchboardResponse createSwitchboard(String appId) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling createSwitchboard");
        }
        String localVarPath = "/v2/apps/{appId}/switchboards".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<SwitchboardResponse> localVarReturnType = new GenericType<SwitchboardResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Object deleteSwitchboard(String appId, String switchboardId) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling deleteSwitchboard");
        }
        if (switchboardId == null) {
            throw new ApiException(400, "Missing the required parameter 'switchboardId' when calling deleteSwitchboard");
        }
        String localVarPath = "/v2/apps/{appId}/switchboards/{switchboardId}".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{switchboardId\\}", this.apiClient.escapeString(switchboardId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public SwitchboardListResponse listSwitchboards(String appId) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling listSwitchboards");
        }
        String localVarPath = "/v2/apps/{appId}/switchboards".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<SwitchboardListResponse> localVarReturnType = new GenericType<SwitchboardListResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public SwitchboardResponse updateSwitchboard(SwitchboardUpdateBody switchboardUpdateBody, String appId, String switchboardId) throws ApiException {
        SwitchboardUpdateBody localVarPostBody = switchboardUpdateBody;
        if (switchboardUpdateBody == null) {
            throw new ApiException(400, "Missing the required parameter 'switchboardUpdateBody' when calling updateSwitchboard");
        }
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling updateSwitchboard");
        }
        if (switchboardId == null) {
            throw new ApiException(400, "Missing the required parameter 'switchboardId' when calling updateSwitchboard");
        }
        String localVarPath = "/v2/apps/{appId}/switchboards/{switchboardId}".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{switchboardId\\}", this.apiClient.escapeString(switchboardId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<SwitchboardResponse> localVarReturnType = new GenericType<SwitchboardResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public SwitchboardResponse createSwitchboard(String bearerToken, String appId) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling createSwitchboard");
        }
        String localVarPath = "/v2/apps/{appId}/switchboards".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Authorization", "Bearer " + bearerToken);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<SwitchboardResponse> localVarReturnType = new GenericType<SwitchboardResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Object deleteSwitchboard(String bearerToken, String appId, String switchboardId) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling deleteSwitchboard");
        }
        if (switchboardId == null) {
            throw new ApiException(400, "Missing the required parameter 'switchboardId' when calling deleteSwitchboard");
        }
        String localVarPath = "/v2/apps/{appId}/switchboards/{switchboardId}".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{switchboardId\\}", this.apiClient.escapeString(switchboardId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Authorization", "Bearer " + bearerToken);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public SwitchboardListResponse listSwitchboards(String bearerToken, String appId) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling listSwitchboards");
        }
        String localVarPath = "/v2/apps/{appId}/switchboards".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Authorization", "Bearer " + bearerToken);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<SwitchboardListResponse> localVarReturnType = new GenericType<SwitchboardListResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public SwitchboardResponse updateSwitchboard(String bearerToken, SwitchboardUpdateBody switchboardUpdateBody, String appId, String switchboardId) throws ApiException {
        SwitchboardUpdateBody localVarPostBody = switchboardUpdateBody;
        if (switchboardUpdateBody == null) {
            throw new ApiException(400, "Missing the required parameter 'switchboardUpdateBody' when calling updateSwitchboard");
        }
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling updateSwitchboard");
        }
        if (switchboardId == null) {
            throw new ApiException(400, "Missing the required parameter 'switchboardId' when calling updateSwitchboard");
        }
        String localVarPath = "/v2/apps/{appId}/switchboards/{switchboardId}".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{switchboardId\\}", this.apiClient.escapeString(switchboardId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Authorization", "Bearer " + bearerToken);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<SwitchboardResponse> localVarReturnType = new GenericType<SwitchboardResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

