/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.api;

import com.zendesk.sunshine_conversations_client.ApiClient;
import com.zendesk.sunshine_conversations_client.ApiException;
import com.zendesk.sunshine_conversations_client.Configuration;
import com.zendesk.sunshine_conversations_client.Pair;
import com.zendesk.sunshine_conversations_client.model.WebhookBody;
import com.zendesk.sunshine_conversations_client.model.WebhookCreateBody;
import com.zendesk.sunshine_conversations_client.model.WebhookListResponse;
import com.zendesk.sunshine_conversations_client.model.WebhookResponse;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class WebhooksApi {
    private ApiClient apiClient;

    public WebhooksApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WebhooksApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public WebhookResponse createWebhook(WebhookCreateBody webhookCreateBody, String appId, String integrationId) throws ApiException {
        WebhookCreateBody localVarPostBody = webhookCreateBody;
        if (webhookCreateBody == null) {
            throw new ApiException(400, "Missing the required parameter 'webhookCreateBody' when calling createWebhook");
        }
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling createWebhook");
        }
        if (integrationId == null) {
            throw new ApiException(400, "Missing the required parameter 'integrationId' when calling createWebhook");
        }
        String localVarPath = "/v2/apps/{appId}/integrations/{integrationId}/webhooks".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{integrationId\\}", this.apiClient.escapeString(integrationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<WebhookResponse> localVarReturnType = new GenericType<WebhookResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Object deleteWebhook(String appId, String integrationId, String webhookId) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling deleteWebhook");
        }
        if (integrationId == null) {
            throw new ApiException(400, "Missing the required parameter 'integrationId' when calling deleteWebhook");
        }
        if (webhookId == null) {
            throw new ApiException(400, "Missing the required parameter 'webhookId' when calling deleteWebhook");
        }
        String localVarPath = "/v2/apps/{appId}/integrations/{integrationId}/webhooks/{webhookId}".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{integrationId\\}", this.apiClient.escapeString(integrationId.toString())).replaceAll("\\{webhookId\\}", this.apiClient.escapeString(webhookId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public WebhookResponse getWebhook(String appId, String integrationId, String webhookId) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling getWebhook");
        }
        if (integrationId == null) {
            throw new ApiException(400, "Missing the required parameter 'integrationId' when calling getWebhook");
        }
        if (webhookId == null) {
            throw new ApiException(400, "Missing the required parameter 'webhookId' when calling getWebhook");
        }
        String localVarPath = "/v2/apps/{appId}/integrations/{integrationId}/webhooks/{webhookId}".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{integrationId\\}", this.apiClient.escapeString(integrationId.toString())).replaceAll("\\{webhookId\\}", this.apiClient.escapeString(webhookId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<WebhookResponse> localVarReturnType = new GenericType<WebhookResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public WebhookListResponse listWebhooks(String appId, String integrationId) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling listWebhooks");
        }
        if (integrationId == null) {
            throw new ApiException(400, "Missing the required parameter 'integrationId' when calling listWebhooks");
        }
        String localVarPath = "/v2/apps/{appId}/integrations/{integrationId}/webhooks".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{integrationId\\}", this.apiClient.escapeString(integrationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<WebhookListResponse> localVarReturnType = new GenericType<WebhookListResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public WebhookResponse updateWebhook(WebhookBody webhookBody, String appId, String integrationId, String webhookId) throws ApiException {
        WebhookBody localVarPostBody = webhookBody;
        if (webhookBody == null) {
            throw new ApiException(400, "Missing the required parameter 'webhookBody' when calling updateWebhook");
        }
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling updateWebhook");
        }
        if (integrationId == null) {
            throw new ApiException(400, "Missing the required parameter 'integrationId' when calling updateWebhook");
        }
        if (webhookId == null) {
            throw new ApiException(400, "Missing the required parameter 'webhookId' when calling updateWebhook");
        }
        String localVarPath = "/v2/apps/{appId}/integrations/{integrationId}/webhooks/{webhookId}".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{integrationId\\}", this.apiClient.escapeString(integrationId.toString())).replaceAll("\\{webhookId\\}", this.apiClient.escapeString(webhookId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<WebhookResponse> localVarReturnType = new GenericType<WebhookResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public WebhookResponse createWebhook(String bearerToken, WebhookCreateBody webhookCreateBody, String appId, String integrationId) throws ApiException {
        WebhookCreateBody localVarPostBody = webhookCreateBody;
        if (webhookCreateBody == null) {
            throw new ApiException(400, "Missing the required parameter 'webhookCreateBody' when calling createWebhook");
        }
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling createWebhook");
        }
        if (integrationId == null) {
            throw new ApiException(400, "Missing the required parameter 'integrationId' when calling createWebhook");
        }
        String localVarPath = "/v2/apps/{appId}/integrations/{integrationId}/webhooks".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{integrationId\\}", this.apiClient.escapeString(integrationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Authorization", "Bearer " + bearerToken);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<WebhookResponse> localVarReturnType = new GenericType<WebhookResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Object deleteWebhook(String bearerToken, String appId, String integrationId, String webhookId) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling deleteWebhook");
        }
        if (integrationId == null) {
            throw new ApiException(400, "Missing the required parameter 'integrationId' when calling deleteWebhook");
        }
        if (webhookId == null) {
            throw new ApiException(400, "Missing the required parameter 'webhookId' when calling deleteWebhook");
        }
        String localVarPath = "/v2/apps/{appId}/integrations/{integrationId}/webhooks/{webhookId}".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{integrationId\\}", this.apiClient.escapeString(integrationId.toString())).replaceAll("\\{webhookId\\}", this.apiClient.escapeString(webhookId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Authorization", "Bearer " + bearerToken);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public WebhookResponse getWebhook(String bearerToken, String appId, String integrationId, String webhookId) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling getWebhook");
        }
        if (integrationId == null) {
            throw new ApiException(400, "Missing the required parameter 'integrationId' when calling getWebhook");
        }
        if (webhookId == null) {
            throw new ApiException(400, "Missing the required parameter 'webhookId' when calling getWebhook");
        }
        String localVarPath = "/v2/apps/{appId}/integrations/{integrationId}/webhooks/{webhookId}".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{integrationId\\}", this.apiClient.escapeString(integrationId.toString())).replaceAll("\\{webhookId\\}", this.apiClient.escapeString(webhookId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Authorization", "Bearer " + bearerToken);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<WebhookResponse> localVarReturnType = new GenericType<WebhookResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public WebhookListResponse listWebhooks(String bearerToken, String appId, String integrationId) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling listWebhooks");
        }
        if (integrationId == null) {
            throw new ApiException(400, "Missing the required parameter 'integrationId' when calling listWebhooks");
        }
        String localVarPath = "/v2/apps/{appId}/integrations/{integrationId}/webhooks".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{integrationId\\}", this.apiClient.escapeString(integrationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Authorization", "Bearer " + bearerToken);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<WebhookListResponse> localVarReturnType = new GenericType<WebhookListResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public WebhookResponse updateWebhook(String bearerToken, WebhookBody webhookBody, String appId, String integrationId, String webhookId) throws ApiException {
        WebhookBody localVarPostBody = webhookBody;
        if (webhookBody == null) {
            throw new ApiException(400, "Missing the required parameter 'webhookBody' when calling updateWebhook");
        }
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling updateWebhook");
        }
        if (integrationId == null) {
            throw new ApiException(400, "Missing the required parameter 'integrationId' when calling updateWebhook");
        }
        if (webhookId == null) {
            throw new ApiException(400, "Missing the required parameter 'webhookId' when calling updateWebhook");
        }
        String localVarPath = "/v2/apps/{appId}/integrations/{integrationId}/webhooks/{webhookId}".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{integrationId\\}", this.apiClient.escapeString(integrationId.toString())).replaceAll("\\{webhookId\\}", this.apiClient.escapeString(webhookId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Authorization", "Bearer " + bearerToken);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<WebhookResponse> localVarReturnType = new GenericType<WebhookResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

