/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.zendesk.sunshine_conversations_client.model.Author;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"author", "type"})
public class ActivityPost {
    public static final String JSON_PROPERTY_AUTHOR = "author";
    private Author author = null;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public ActivityPost author(Author author) {
        this.author = author;
        return this;
    }

    @ApiModelProperty(required=true, value="The author of the activity.")
    @JsonProperty(value="author")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Author getAuthor() {
        return this.author;
    }

    public void setAuthor(Author author) {
        this.author = author;
    }

    public ActivityPost type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="If the author type is `user`, only `conversation:read` is supported.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActivityPost activityPost = (ActivityPost)o;
        return Objects.equals(this.author, activityPost.author) && Objects.equals((Object)this.type, (Object)activityPost.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.author, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ActivityPost {\n");
        sb.append("    author: ").append(this.toIndentedString(this.author)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        CONVERSATION_READ("conversation:read"),
        TYPING_START("typing:start"),
        TYPING_STOP("typing:stop");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

