/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"id", "displayName", "secret"})
public class AppKey {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private String displayName;
    public static final String JSON_PROPERTY_SECRET = "secret";
    private String secret;

    public AppKey id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="app_5723a347f82ba0516cb4ea34", value="The unique ID of the API key, used when signing JWTs or accessing the API using Basic Authentication.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AppKey displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Key 1", value="The name of the API key.")
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public AppKey secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="5XJ85yjUtRcaQu_pDINblPZb", value="The secret of the API key, used when signing JWTs or accessing the API using Basic Authentication")
    @JsonProperty(value="secret")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppKey appKey = (AppKey)o;
        return Objects.equals(this.id, appKey.id) && Objects.equals(this.displayName, appKey.displayName) && Objects.equals(this.secret, appKey.secret);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.displayName, this.secret);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppKey {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

