/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.ConversationTruncated;
import com.zendesk.sunshine_conversations_client.model.MessageWebhook;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The payload of the event. The contents of this object depend on the type of event.")
@JsonPropertyOrder(value={"conversation", "message", "recentNotifications"})
public class ConversationMessageEventAllOfPayload {
    public static final String JSON_PROPERTY_CONVERSATION = "conversation";
    private ConversationTruncated conversation = null;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private MessageWebhook message = null;
    public static final String JSON_PROPERTY_RECENT_NOTIFICATIONS = "recentNotifications";
    private List<MessageWebhook> recentNotifications = null;

    public ConversationMessageEventAllOfPayload conversation(ConversationTruncated conversation) {
        this.conversation = conversation;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The conversation in which the message was sent.")
    @JsonProperty(value="conversation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ConversationTruncated getConversation() {
        return this.conversation;
    }

    public void setConversation(ConversationTruncated conversation) {
        this.conversation = conversation;
    }

    public ConversationMessageEventAllOfPayload message(MessageWebhook message) {
        this.message = message;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The message that was sent.")
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MessageWebhook getMessage() {
        return this.message;
    }

    public void setMessage(MessageWebhook message) {
        this.message = message;
    }

    public ConversationMessageEventAllOfPayload recentNotifications(List<MessageWebhook> recentNotifications) {
        this.recentNotifications = recentNotifications;
        return this;
    }

    public ConversationMessageEventAllOfPayload addRecentNotificationsItem(MessageWebhook recentNotificationsItem) {
        if (this.recentNotifications == null) {
            this.recentNotifications = new ArrayList<MessageWebhook>();
        }
        this.recentNotifications.add(recentNotificationsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Messages sent with the Notification API since the last user message.")
    @JsonProperty(value="recentNotifications")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<MessageWebhook> getRecentNotifications() {
        return this.recentNotifications;
    }

    public void setRecentNotifications(List<MessageWebhook> recentNotifications) {
        this.recentNotifications = recentNotifications;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationMessageEventAllOfPayload conversationMessageEventAllOfPayload = (ConversationMessageEventAllOfPayload)o;
        return Objects.equals(this.conversation, conversationMessageEventAllOfPayload.conversation) && Objects.equals(this.message, conversationMessageEventAllOfPayload.message) && Objects.equals(this.recentNotifications, conversationMessageEventAllOfPayload.recentNotifications);
    }

    public int hashCode() {
        return Objects.hash(this.conversation, this.message, this.recentNotifications);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationMessageEventAllOfPayload {\n");
        sb.append("    conversation: ").append(this.toIndentedString(this.conversation)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    recentNotifications: ").append(this.toIndentedString(this.recentNotifications)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

