/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.ConversationType;
import com.zendesk.sunshine_conversations_client.model.SwitchboardIntegrationWebhook;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"id", "type", "metadata", "activeSwitchboardIntegration", "pendingSwitchboardIntegration"})
public class ConversationTruncated {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_TYPE = "type";
    private ConversationType type;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private JsonNullable<Object> metadata = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ACTIVE_SWITCHBOARD_INTEGRATION = "activeSwitchboardIntegration";
    private JsonNullable<SwitchboardIntegrationWebhook> activeSwitchboardIntegration = JsonNullable.of(null);
    public static final String JSON_PROPERTY_PENDING_SWITCHBOARD_INTEGRATION = "pendingSwitchboardIntegration";
    private JsonNullable<SwitchboardIntegrationWebhook> pendingSwitchboardIntegration = JsonNullable.of(null);

    public ConversationTruncated id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="c93bb9c14dde8ffb94564eae", value="The unique ID of the conversation.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ConversationTruncated type(ConversationType type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ConversationType getType() {
        return this.type;
    }

    public void setType(ConversationType type) {
        this.type = type;
    }

    public ConversationTruncated metadata(Object metadata) {
        this.metadata = JsonNullable.of((Object)metadata);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"lang\":\"en-ca\"}", value="Flat object containing custom properties. Strings, numbers and booleans  are the only supported format that can be passed to metadata. The metadata is limited to 4KB in size. ")
    @JsonIgnore
    public Object getMetadata() {
        return this.metadata.orElse(null);
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Object> getMetadata_JsonNullable() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata_JsonNullable(JsonNullable<Object> metadata) {
        this.metadata = metadata;
    }

    public void setMetadata(Object metadata) {
        this.metadata = JsonNullable.of((Object)metadata);
    }

    public ConversationTruncated activeSwitchboardIntegration(SwitchboardIntegrationWebhook activeSwitchboardIntegration) {
        this.activeSwitchboardIntegration = JsonNullable.of((Object)activeSwitchboardIntegration);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The current switchboard integration that is in control of the conversation. This field is omitted if no `activeSwitchboardIntegration` exists for the conversation.")
    @JsonIgnore
    public SwitchboardIntegrationWebhook getActiveSwitchboardIntegration() {
        return (SwitchboardIntegrationWebhook)this.activeSwitchboardIntegration.orElse(null);
    }

    @JsonProperty(value="activeSwitchboardIntegration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<SwitchboardIntegrationWebhook> getActiveSwitchboardIntegration_JsonNullable() {
        return this.activeSwitchboardIntegration;
    }

    @JsonProperty(value="activeSwitchboardIntegration")
    public void setActiveSwitchboardIntegration_JsonNullable(JsonNullable<SwitchboardIntegrationWebhook> activeSwitchboardIntegration) {
        this.activeSwitchboardIntegration = activeSwitchboardIntegration;
    }

    public void setActiveSwitchboardIntegration(SwitchboardIntegrationWebhook activeSwitchboardIntegration) {
        this.activeSwitchboardIntegration = JsonNullable.of((Object)activeSwitchboardIntegration);
    }

    public ConversationTruncated pendingSwitchboardIntegration(SwitchboardIntegrationWebhook pendingSwitchboardIntegration) {
        this.pendingSwitchboardIntegration = JsonNullable.of((Object)pendingSwitchboardIntegration);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The switchboard integration that is awaiting control. This field is omitted if no switchboard integration has been previously offered control.")
    @JsonIgnore
    public SwitchboardIntegrationWebhook getPendingSwitchboardIntegration() {
        return (SwitchboardIntegrationWebhook)this.pendingSwitchboardIntegration.orElse(null);
    }

    @JsonProperty(value="pendingSwitchboardIntegration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<SwitchboardIntegrationWebhook> getPendingSwitchboardIntegration_JsonNullable() {
        return this.pendingSwitchboardIntegration;
    }

    @JsonProperty(value="pendingSwitchboardIntegration")
    public void setPendingSwitchboardIntegration_JsonNullable(JsonNullable<SwitchboardIntegrationWebhook> pendingSwitchboardIntegration) {
        this.pendingSwitchboardIntegration = pendingSwitchboardIntegration;
    }

    public void setPendingSwitchboardIntegration(SwitchboardIntegrationWebhook pendingSwitchboardIntegration) {
        this.pendingSwitchboardIntegration = JsonNullable.of((Object)pendingSwitchboardIntegration);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationTruncated conversationTruncated = (ConversationTruncated)o;
        return Objects.equals(this.id, conversationTruncated.id) && Objects.equals((Object)this.type, (Object)conversationTruncated.type) && Objects.equals(this.metadata, conversationTruncated.metadata) && Objects.equals(this.activeSwitchboardIntegration, conversationTruncated.activeSwitchboardIntegration) && Objects.equals(this.pendingSwitchboardIntegration, conversationTruncated.pendingSwitchboardIntegration);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.type, this.metadata, this.activeSwitchboardIntegration, this.pendingSwitchboardIntegration});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationTruncated {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    activeSwitchboardIntegration: ").append(this.toIndentedString(this.activeSwitchboardIntegration)).append("\n");
        sb.append("    pendingSwitchboardIntegration: ").append(this.toIndentedString(this.pendingSwitchboardIntegration)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

