/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"displayName", "description", "iconUrl", "metadata"})
public class ConversationUpdateBody {
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private String displayName = null;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private JsonNullable<String> description = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ICON_URL = "iconUrl";
    private JsonNullable<URI> iconUrl = JsonNullable.undefined();
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private JsonNullable<Object> metadata = JsonNullable.undefined();

    public ConversationUpdateBody displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="My conversation", value="A friendly name for the conversation, may be displayed to the business or the user. ")
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ConversationUpdateBody description(String description) {
        this.description = JsonNullable.of((Object)description);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Conversation between Rogers and Carl.", value="A short text describing the conversation.")
    @JsonIgnore
    public String getDescription() {
        return (String)this.description.orElse(null);
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDescription_JsonNullable() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription_JsonNullable(JsonNullable<String> description) {
        this.description = description;
    }

    public void setDescription(String description) {
        this.description = JsonNullable.of((Object)description);
    }

    public ConversationUpdateBody iconUrl(URI iconUrl) {
        this.iconUrl = JsonNullable.of((Object)iconUrl);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://www.gravatar.com/image.jpg", value="A custom conversation icon url. The image must be in either JPG, PNG, or GIF format")
    @JsonIgnore
    public URI getIconUrl() {
        return (URI)this.iconUrl.orElse(null);
    }

    @JsonProperty(value="iconUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<URI> getIconUrl_JsonNullable() {
        return this.iconUrl;
    }

    @JsonProperty(value="iconUrl")
    public void setIconUrl_JsonNullable(JsonNullable<URI> iconUrl) {
        this.iconUrl = iconUrl;
    }

    public void setIconUrl(URI iconUrl) {
        this.iconUrl = JsonNullable.of((Object)iconUrl);
    }

    public ConversationUpdateBody metadata(Object metadata) {
        this.metadata = JsonNullable.of((Object)metadata);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"lang\":\"en-ca\"}", value="Flat object containing custom properties. Strings, numbers and booleans  are the only supported format that can be passed to metadata. The metadata is limited to 4KB in size. ")
    @JsonIgnore
    public Object getMetadata() {
        return this.metadata.orElse(null);
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Object> getMetadata_JsonNullable() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata_JsonNullable(JsonNullable<Object> metadata) {
        this.metadata = metadata;
    }

    public void setMetadata(Object metadata) {
        this.metadata = JsonNullable.of((Object)metadata);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationUpdateBody conversationUpdateBody = (ConversationUpdateBody)o;
        return Objects.equals(this.displayName, conversationUpdateBody.displayName) && Objects.equals(this.description, conversationUpdateBody.description) && Objects.equals(this.iconUrl, conversationUpdateBody.iconUrl) && Objects.equals(this.metadata, conversationUpdateBody.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.displayName, this.description, this.iconUrl, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationUpdateBody {\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    iconUrl: ").append(this.toIndentedString(this.iconUrl)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

